/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.kafka.resource.local;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class ZookeeperContainer
extends GenericContainer<ZookeeperContainer> {
    public static final String CONTAINER_NAME = "zookeeper";
    public static final int ZOOKEEPER_PORT = 2181;

    public ZookeeperContainer(String image, Network network) {
        super(image);
        this.withNetwork(network);
        this.withCreateContainerCmdModifier(cmd -> {
            cmd.withHostName(CONTAINER_NAME);
            cmd.withName(CONTAINER_NAME);
        });
        this.withExposedPorts(new Integer[]{2181});
        this.addFixedExposedPort(2181, 2181);
        this.withEnv("LOG_DIR", "/tmp/log");
        this.withCommand(new String[]{"sh", "-c", "bin/zookeeper-server-start.sh config/zookeeper.properties"});
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
    }
}

