/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.kafka.resource.local;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class StrimziContainer
extends GenericContainer<StrimziContainer> {
    private static final String CONTAINER_NAME = "kafka";
    private static final int KAFKA_PORT = 9092;

    public StrimziContainer(String image, Network network) {
        super(image);
        this.withNetwork(network);
        this.withCreateContainerCmdModifier(cmd -> {
            cmd.withHostName(CONTAINER_NAME);
            cmd.withName(CONTAINER_NAME);
        });
        this.withExposedPorts(new Integer[]{9092});
        this.addFixedExposedPort(9092, 9092);
        this.withEnv("LOG_DIR", "/tmp/log");
        this.withCommand(new String[]{"sh", "-c", String.format("bin/kafka-server-start.sh config/server.properties --override zookeeper.connect=%s:%d --override advertised.listeners=PLAINTEXT://%s:%d", "zookeeper", 2181, "localhost", 9092)});
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public int getKafkaPort() {
        return this.getMappedPort(9092);
    }
}

