/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.kafka.resource.local;

import com.google.auto.service.AutoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import software.tnb.common.deployment.Deployable;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.kafka.resource.local.StrimziContainer;
import software.tnb.kafka.resource.local.ZookeeperContainer;
import software.tnb.kafka.service.Kafka;

@AutoService(value={Kafka.class})
public class LocalKafka
extends Kafka
implements Deployable,
WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalKafka.class);
    private StrimziContainer strimziContainer;
    private ZookeeperContainer zookeeperContainer;

    @Override
    public String bootstrapServers() {
        return this.strimziContainer.getContainerIpAddress() + ":" + this.strimziContainer.getKafkaPort();
    }

    @Override
    public String bootstrapSSLServers() {
        return this.bootstrapServers();
    }

    @Override
    public void createTopic(String name, int partitions, int replicas) {
    }

    public void deploy() {
        Network network = Network.newNetwork();
        LOG.info("Starting Zookeeper container");
        this.zookeeperContainer = new ZookeeperContainer(this.image(), network);
        this.zookeeperContainer.start();
        LOG.info("Zookeeper container started");
        LOG.info("Starting Kafka container");
        this.strimziContainer = new StrimziContainer(this.image(), network);
        this.strimziContainer.start();
        LOG.info("Kafka container started");
    }

    public void undeploy() {
        if (this.strimziContainer != null) {
            LOG.info("Stopping Kafka container");
            this.strimziContainer.stop();
        }
        if (this.zookeeperContainer != null) {
            LOG.info("Stopping Zookeeper container");
            this.zookeeperContainer.stop();
        }
    }

    @Override
    public void openResources() {
        this.props.setProperty("bootstrap.servers", this.bootstrapServers());
        super.openResources();
    }

    public String defaultImage() {
        return "registry.redhat.io/amq7/amq-streams-kafka-31-rhel8:2.1.0";
    }
}

