/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.jaeger.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import software.tnb.common.account.NoAccount;
import software.tnb.common.service.ConfigurableService;
import software.tnb.jaeger.client.JaegerClient;
import software.tnb.jaeger.service.configuration.JaegerConfiguration;
import software.tnb.jaeger.validation.JaegerValidation;

public abstract class Jaeger
extends ConfigurableService<NoAccount, JaegerClient, JaegerValidation, JaegerConfiguration> {
    protected JaegerValidation validation;

    public abstract String getLog();

    public abstract String getCollectorUrl(JaegerConfiguration.CollectorPort var1);

    public abstract String getQueryUrl(JaegerConfiguration.QueryPort var1);

    public abstract String getExternalUrl();

    protected void defaultConfiguration() {
    }

    protected Map<String, String> env() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("COLLECTOR_OTLP_ENABLED", "true");
        env.put("SPAN_STORAGE_TYPE", "memory");
        env.put("JAEGER_DISABLED", "false");
        if (StringUtils.isNotEmpty((CharSequence)((JaegerConfiguration)this.getConfiguration()).getPrometheusUrl())) {
            env.put("PROMETHEUS_SERVER_URL", ((JaegerConfiguration)this.getConfiguration()).getPrometheusUrl());
            env.put("METRICS_STORAGE_TYPE", "prometheus");
        }
        return env;
    }

    public JaegerValidation validation() {
        return Optional.ofNullable(this.validation).orElseGet(() -> {
            this.validation = new JaegerValidation((JaegerClient)this.client());
            return this.validation;
        });
    }
}

