/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.jaeger.resource.openshift;

import com.google.auto.service.AutoService;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithExternalHostname;
import software.tnb.common.deployment.WithOperatorHub;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.jaeger.client.JaegerClient;
import software.tnb.jaeger.client.UnauthenticatedJaegerClient;
import software.tnb.jaeger.service.Jaeger;
import software.tnb.jaeger.service.configuration.JaegerConfiguration;

@AutoService(value={Jaeger.class})
public class OpenshiftJaeger
extends Jaeger
implements OpenshiftDeployable,
WithExternalHostname,
WithOperatorHub {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftJaeger.class);
    private static final String CRD_GROUP = "jaegertracing.io";
    private static final String CRD_VERSION = "v1";
    private static final CustomResourceDefinitionContext JAEGER_CTX = new CustomResourceDefinitionContext.Builder().withName("Jaeger").withGroup("jaegertracing.io").withVersion("v1").withPlural("jaegers").withScope("Namespaced").build();
    private static final String JAEGER_INSTANCE_NAME = "jaeger-all-in-one-inmemory";

    public void undeploy() {
    }

    public void openResources() {
    }

    public void closeResources() {
        this.validation = null;
    }

    public void create() {
        LOG.debug("Creating Jaeger subscription");
        this.createSubscription();
        try {
            OpenshiftClient.get().customResource(JAEGER_CTX).inNamespace(this.targetNamespace()).createOrReplace(this.createCr(JAEGER_INSTANCE_NAME));
        }
        catch (IOException e) {
            Assertions.fail((String)"Unable to create Jaeger instance", (Throwable)e);
        }
    }

    public boolean isDeployed() {
        return ((DeploymentList)((NonNamespaceOperation)OpenshiftClient.get().apps().deployments().inNamespace(this.targetNamespace())).list()).getItems().stream().anyMatch(deployment -> JAEGER_INSTANCE_NAME.equals(deployment.getMetadata().getName()));
    }

    public Predicate<Pod> podSelector() {
        return p -> OpenshiftClient.get().hasLabels(p, Map.of("app", "jaeger", "app.kubernetes.io/name", JAEGER_INSTANCE_NAME));
    }

    public String externalHostname() {
        return "https://" + OpenshiftClient.get().getRoute(JAEGER_INSTANCE_NAME).getSpec().getHost();
    }

    public String operatorName() {
        return "jaeger-product";
    }

    @Override
    public String getLog() {
        return OpenshiftClient.get().getPodLog((Pod)this.servicePod().get(), "jaeger");
    }

    @Override
    public String getCollectorUrl(JaegerConfiguration.CollectorPort port) {
        return String.format("http://%s-collector:%s", JAEGER_INSTANCE_NAME, port.portNumber());
    }

    @Override
    public String getQueryUrl(JaegerConfiguration.QueryPort port) {
        return String.format("http://%s-query:%s", JAEGER_INSTANCE_NAME, port.portNumber());
    }

    @Override
    public String getExternalUrl() {
        return this.externalHostname();
    }

    protected JaegerClient client() {
        return new UnauthenticatedJaegerClient(this.getExternalUrl());
    }

    public boolean clusterWide() {
        return true;
    }

    private Map<String, Object> createCr(String name) {
        HashMap<String, Object> cr = new HashMap<String, Object>();
        cr.put("apiVersion", "jaegertracing.io/v1");
        cr.put("kind", "Jaeger");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("name", name);
        metadata.put("namespace", this.targetNamespace());
        cr.put("metadata", metadata);
        HashMap<String, Object> spec = new HashMap<String, Object>();
        spec.put("strategy", "allInOne");
        if (this.env().containsKey("PROMETHEUS_SERVER_URL")) {
            HashMap<String, Map<String, String>> allInOneConfig = new HashMap<String, Map<String, String>>();
            HashMap<String, Map<String, String>> optionsConfig = new HashMap<String, Map<String, String>>();
            optionsConfig.put("prometheus", Map.of("server-url", this.env().get("PROMETHEUS_SERVER_URL")));
            allInOneConfig.put("metricsStorage", Map.of("type", "prometheus"));
            allInOneConfig.put("options", optionsConfig);
            spec.put("allInOne", allInOneConfig);
        }
        spec.put("ingress", Map.of("security", "none"));
        cr.put("spec", spec);
        return cr;
    }
}

