/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.jaeger.resource.local;

import com.google.auto.service.AutoService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.jaeger.client.JaegerClient;
import software.tnb.jaeger.client.UnauthenticatedJaegerClient;
import software.tnb.jaeger.resource.local.JaegerContainer;
import software.tnb.jaeger.service.Jaeger;
import software.tnb.jaeger.service.configuration.JaegerConfiguration;

@AutoService(value={Jaeger.class})
public class LocalJaeger
extends Jaeger
implements Deployable,
WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalJaeger.class);
    private JaegerContainer container;

    public void deploy() {
        LOG.info("Starting Jaeger container");
        this.container = new JaegerContainer(this.image(), this.env());
        this.container.start();
        LOG.info("Jaeger container started");
    }

    public void undeploy() {
        if (this.container != null) {
            LOG.info("Stopping Jaeger container");
            this.container.stop();
        }
    }

    public void openResources() {
    }

    public void closeResources() {
        this.validation = null;
    }

    @Override
    public String getLog() {
        return this.container.getLogs();
    }

    @Override
    public String getCollectorUrl(JaegerConfiguration.CollectorPort port) {
        return this.getUrl(port);
    }

    @Override
    public String getQueryUrl(JaegerConfiguration.QueryPort port) {
        return this.getUrl(port);
    }

    @Override
    public String getExternalUrl() {
        return this.getQueryUrl(JaegerConfiguration.QueryPort.HTTP);
    }

    protected JaegerClient client() {
        return new UnauthenticatedJaegerClient(this.getQueryUrl(JaegerConfiguration.QueryPort.HTTP));
    }

    @NotNull
    private String getUrl(JaegerConfiguration.WithPort port) {
        return String.format("http://%s:%d", this.container.getHost(), port.portNumber());
    }

    public String defaultImage() {
        return "registry.redhat.io/rhosdt/jaeger-all-in-one-rhel8:latest";
    }
}

