/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.jaeger.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import software.tnb.common.utils.HTTPUtils;
import software.tnb.common.utils.WaitUtils;
import software.tnb.jaeger.client.BaseJaegerClient;
import software.tnb.jaeger.client.JaegerClient;
import software.tnb.jaeger.validation.model.Span;

public class UnauthenticatedJaegerClient
extends BaseJaegerClient
implements JaegerClient {
    private static final int MAX_RETRIES_IN_SECONDS = 15;
    private final HTTPUtils apiClient = HTTPUtils.getInstance((OkHttpClient)HTTPUtils.trustAllSslClient());

    public UnauthenticatedJaegerClient(String queryUrl) {
        super(queryUrl);
    }

    private String getRawJsonTrace(String traceId) {
        String url = this.apiTraceId(traceId);
        WaitUtils.waitFor(() -> this.apiClient.get(url).isSuccessful(), (int)15, (long)1000L, (String)"Wait for the trace to be elaborated");
        return this.apiClient.get(url).getBody();
    }

    @Override
    public Map<String, Object> getTrace(String traceId) {
        try {
            return (Map)this.objectMapper.readValue(this.getRawJsonTrace(traceId), Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("unable to read json from response", e);
        }
    }

    @Override
    public List<Span> getSpans(String traceId) {
        Map data = (Map)((List)this.getTrace(traceId).get("data")).get(0);
        String serviceName = (String)((Map)Optional.ofNullable(((Map)data.get("processes")).get("p1")).orElseGet(() -> Map.of("serviceName", ""))).get("serviceName");
        List spans = (List)this.objectMapper.convertValue(data.get("spans"), (TypeReference)new TypeReference<List<Span>>(){});
        return spans.stream().map(span -> span.withServiceName(serviceName)).collect(Collectors.toList());
    }
}

