/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.infinispan.resource.openshift;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShiftWaiters;
import cz.xtf.core.openshift.helpers.ResourceFunctions;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.ReusableOpenshiftDeployable;
import software.tnb.common.deployment.WithName;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.infinispan.service.Infinispan;

@AutoService(value={Infinispan.class})
public class OpenshiftInfinispan
extends Infinispan
implements ReusableOpenshiftDeployable,
WithName {
    public void undeploy() {
        ((DeployableScalableResource)OpenshiftClient.get().deploymentConfigs().withName(this.name())).delete();
        ((FilterWatchListDeletable)OpenshiftClient.get().services().withLabel(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).delete();
        OpenShiftWaiters.get((OpenShift)OpenshiftClient.get(), () -> false).areNoPodsPresent(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name()).timeout(120000L).waitFor();
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    public void create() {
        try {
            OpenshiftClient.get().createConfigMap("infinispan-config", Map.of("infinispan.xml", IOUtils.resourceToString((String)"/infinispan.xml", (Charset)StandardCharsets.UTF_8)));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        Probe probe = ((ProbeBuilder)new ProbeBuilder().withHttpGet(((HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPort(new IntOrString(Integer.valueOf(11222)))).withPath("/console")).build())).build();
        OpenshiftClient.get().deploymentConfigs().createOrReplace((Object[])new DeploymentConfig[]{((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.VolumesNested)((PodSpecFluent.VolumesNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).withReplicas(Integer.valueOf(1))).editOrNewTemplate().editOrNewMetadata().addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addNewContainer().withName(this.name())).withImage(this.defaultImage())).withArgs(new String[]{"-c", "/user-config/infinispan.xml"})).addNewPort().withContainerPort(Integer.valueOf(11222))).withName(this.name())).endPort()).addAllToEnv((Collection)this.containerEnvironment().entrySet().stream().map(e -> new EnvVar((String)e.getKey(), (String)e.getValue(), null)).collect(Collectors.toList()))).addNewVolumeMount().withName("infinispan-config")).withMountPath("/user-config")).endVolumeMount()).withReadinessProbe(probe)).withLivenessProbe(probe)).endContainer()).addNewVolume().withName("infinispan-config")).withConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName("infinispan-config")).build())).endVolume()).endSpec()).endTemplate()).addNewTrigger().withType("ConfigChange")).endTrigger()).endSpec()).build()});
        OpenshiftClient.get().services().createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).addNewPort().withName(this.name())).withProtocol("TCP")).withPort(Integer.valueOf(11222))).withTargetPort(new IntOrString(Integer.valueOf(11222)))).endPort()).endSpec()).build()});
    }

    public boolean isReady() {
        List list = OpenshiftClient.get().getLabeledPods(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name());
        return (Boolean)ResourceFunctions.areExactlyNPodsReady((int)1).apply(list);
    }

    public boolean isDeployed() {
        return OpenshiftClient.get().getLabeledPods(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name()).size() > 0;
    }

    public void cleanup() {
    }

    public String name() {
        return "infinispan";
    }

    @Override
    public int getPortMapping() {
        return 11222;
    }

    @Override
    public String getHost() {
        return this.name();
    }
}

