/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.infinispan.resource.local;

import com.google.auto.service.AutoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.infinispan.resource.local.InfinispanContainer;
import software.tnb.infinispan.service.Infinispan;

@AutoService(value={Infinispan.class})
public class LocalInfinispan
extends Infinispan
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalInfinispan.class);
    private InfinispanContainer container;

    public void deploy() {
        LOG.info("Starting Infinispan container");
        this.container = new InfinispanContainer(this.defaultImage(), 11222, this.containerEnvironment());
        this.container.start();
        LOG.info("Infinispan container started");
    }

    public void undeploy() {
        if (this.container != null) {
            this.container.stop();
            LOG.info("Infinispan container stopped");
        }
    }

    @Override
    public int getPortMapping() {
        return this.container.getMappedPort(11222);
    }

    @Override
    public String getHost() {
        return "localhost";
    }

    public void openResources() {
    }

    public void closeResources() {
    }
}

