/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.hyperfoil.resource.local;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.hyperfoil.resource.local.HyperfoilContainer;
import software.tnb.hyperfoil.service.Hyperfoil;

@AutoService(value={Hyperfoil.class})
public class LocalHyperfoil
extends Hyperfoil
implements Deployable,
WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalHyperfoil.class);
    private HyperfoilContainer container;

    public void deploy() {
        LOG.info("Starting Hyperfoil");
        this.container = new HyperfoilContainer(this.image(), new HashMap<String, String>());
        this.container.start();
        LOG.info("Hyperfoil container started");
    }

    public void undeploy() {
        if (this.container != null) {
            LOG.info("Stopping Hyperfoil container");
            this.container.stop();
        }
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    @Override
    public String hyperfoilUrl() {
        return "localhost";
    }

    @Override
    public String connection() {
        return "http://" + this.hyperfoilUrl() + ":" + this.getPortMapping(8090) + "/";
    }

    @Override
    public int getPortMapping(int port) {
        return 8090;
    }

    public String defaultImage() {
        return "quay.io/hyperfoil/hyperfoil:latest";
    }
}

