/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.hyperfoil.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.utils.HTTPUtils;
import software.tnb.hyperfoil.validation.TestResult;
import software.tnb.hyperfoil.validation.generated.ApiClient;
import software.tnb.hyperfoil.validation.generated.ApiException;
import software.tnb.hyperfoil.validation.generated.Configuration;
import software.tnb.hyperfoil.validation.generated.api.DefaultApi;
import software.tnb.hyperfoil.validation.generated.model.RequestStatisticsResponse;
import software.tnb.hyperfoil.validation.generated.model.Run;

public class HyperfoilValidation {
    private static final Logger LOG = LoggerFactory.getLogger(HyperfoilValidation.class);
    private static final Long WAIT_BENCHMARK_SLEEP_TIME = 10000L;
    private static final ObjectMapper yamlMapper = new YAMLMapper();
    private final DefaultApi defaultApi;

    public HyperfoilValidation(String basePath) {
        ApiClient apiClient = Configuration.getDefaultApiClient();
        apiClient.setBasePath(basePath);
        apiClient.setVerifyingSsl(false);
        this.defaultApi = new DefaultApi(apiClient);
    }

    private TestResult doStartAndWaitForBenchmark(Run run) {
        Run finalRun = this.waitForRun(run);
        LOG.info("Benchmark finished");
        LOG.info(this.getRun(run.getId()).toString());
        LOG.info("Generating report");
        String report = this.generateReport(run);
        Path reportFile = this.saveReportToFile(run, report);
        LOG.info("Report generated " + reportFile.toAbsolutePath());
        if (finalRun == null) {
            throw new IllegalStateException("Unexpected error, probably the hyperfoil test, failed");
        }
        try {
            RequestStatisticsResponse totalStats = this.getDefaultApi().getTotalStats(finalRun.getId());
            return new TestResult(finalRun, totalStats);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void startAndWaitForBenchmark(String benchmark) {
        this.startAndWaitForBenchmark(benchmark, null);
    }

    public TestResult startAndWaitForBenchmark(String benchmark, String applicationUnderTestEndpoint) {
        LOG.info("Add benchmark " + benchmark);
        String benchmarkName = this.addBenchmark(benchmark, applicationUnderTestEndpoint);
        LOG.info("Run benchmark");
        Run run = this.runBenchmark(benchmarkName);
        LOG.info("Run started");
        LOG.info(run.toString());
        return this.doStartAndWaitForBenchmark(run);
    }

    public TestResult startAndWaitForBenchmarkTemplate(String benchmark, Map<String, ?> parameters) {
        LOG.info("Add benchmark " + benchmark);
        String benchmarkName = this.addBenchmark(benchmark);
        LOG.info("Run benchmark");
        Run run = this.runBenchmark(benchmarkName, parameters);
        LOG.info("Run started");
        LOG.info(run.toString());
        return this.doStartAndWaitForBenchmark(run);
    }

    private Path saveReportToFile(Run run, String report) {
        try {
            Path destination = Paths.get("target", run.getBenchmark() + "-" + LocalDateTime.now() + ".html");
            software.tnb.common.utils.IOUtils.writeFile((Path)destination, (String)report);
            return destination;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String generateReport(Run run) {
        try {
            return this.getDefaultApi().createReport(run.getId(), null);
        }
        catch (ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String retrieveBenchmarkFile(String benchmarkUri) throws IOException {
        String benchmark;
        if (((String)benchmarkUri).startsWith("http:") || ((String)benchmarkUri).startsWith("https:")) {
            HTTPUtils.Response response = HTTPUtils.getInstance((OkHttpClient)HTTPUtils.trustAllSslClient()).get((String)benchmarkUri);
            if (response.getResponseCode() != 200) {
                throw new RuntimeException("Call to " + (String)benchmarkUri + " failed " + response.getResponseCode() + " " + response.getBody());
            }
            benchmark = response.getBody();
        } else {
            if (!((String)benchmarkUri).startsWith("/")) {
                benchmarkUri = "/" + (String)benchmarkUri;
            }
            try (InputStream is = this.getClass().getResourceAsStream((String)benchmarkUri);){
                byte[] benchmarkByteArray = IOUtils.toByteArray((InputStream)is);
                benchmark = new String(benchmarkByteArray);
            }
        }
        if (benchmark == null) {
            throw new IllegalStateException("Benchmark file at " + (String)benchmarkUri + " not found");
        }
        return benchmark;
    }

    public String addBenchmark(String benchmarkUri) {
        try {
            String benchmark = this.retrieveBenchmarkFile(benchmarkUri);
            Pattern pattern = Pattern.compile("^name:[ ]*(.*)$", 8);
            Matcher matcher = pattern.matcher(benchmark);
            if (!matcher.find()) {
                throw new IllegalArgumentException("the benchmark file don't contain the field 'name'");
            }
            String name = matcher.group(1);
            LOG.info("Using benchmark with name: " + name);
            File tempBenchmarkFile = Files.createTempFile(name, ".yaml", new FileAttribute[0]).toFile();
            Files.writeString(tempBenchmarkFile.toPath(), (CharSequence)benchmark, new OpenOption[0]);
            this.getDefaultApi().addBenchmark(null, null, tempBenchmarkFile);
            return name;
        }
        catch (IOException | ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String addBenchmark(String benchmarkUri, String applicationUnderTestEndpoint) {
        try {
            String benchmark = this.retrieveBenchmarkFile(benchmarkUri);
            ObjectNode node = (ObjectNode)yamlMapper.readValue(benchmark, ObjectNode.class);
            if (Objects.nonNull(applicationUnderTestEndpoint)) {
                JsonNode httpNode = node.get("http");
                if (httpNode.isObject()) {
                    ((ObjectNode)httpNode).put("host", applicationUnderTestEndpoint);
                } else if (httpNode.isArray()) {
                    throw new RuntimeException("Array node detected for http.host, impossible to distinguish which host should be replaced");
                }
            }
            String hyperfoilYaml = yamlMapper.writeValueAsString((Object)node);
            LOG.info("Using the following hyperfoil yaml");
            LOG.info(hyperfoilYaml);
            String name = node.get("name").asText();
            File tempBenchmarkFile = Files.createTempFile(name, ".yaml", new FileAttribute[0]).toFile();
            yamlMapper.writeValue(tempBenchmarkFile, (Object)node);
            this.getDefaultApi().addBenchmark(null, null, tempBenchmarkFile);
            return name;
        }
        catch (IOException | ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Run getRun(String runId) {
        try {
            return this.getDefaultApi().getRun(runId);
        }
        catch (ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new Run();
        }
    }

    public Run waitForRun(Run run) {
        try {
            while (!run.getCompleted().booleanValue()) {
                run = this.getDefaultApi().getRun(run.getId());
                if (LOG.isTraceEnabled()) {
                    LOG.trace(run.toString());
                }
                Thread.sleep(WAIT_BENCHMARK_SLEEP_TIME);
            }
        }
        catch (InterruptedException | ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return run;
    }

    public List<String> listBenchmarks() throws ApiException {
        return this.getDefaultApi().listBenchmarks();
    }

    public Run runBenchmark(String benchmarkName) {
        return this.runBenchmark(benchmarkName, null);
    }

    public Run runBenchmark(String benchmarkName, Map<String, ?> parameters) {
        try {
            if (parameters == null && !this.listBenchmarks().contains(benchmarkName)) {
                throw new RuntimeException("Benchmark with name " + benchmarkName + " does not exists");
            }
            String triggerJob = System.getenv("BUILD_URL") != null ? System.getenv("BUILD_URL") : null;
            List params = null;
            if (parameters != null && parameters.size() > 0) {
                params = parameters.entrySet().stream().map(en -> String.format("%s=%s", en.getKey(), en.getValue().toString())).collect(Collectors.toList());
            }
            return this.getDefaultApi().startBenchmark(benchmarkName, "TNB - " + benchmarkName, triggerJob, null, params);
        }
        catch (ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public DefaultApi getDefaultApi() {
        return this.defaultApi;
    }
}

