/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.hyperfoil.validation.generated;

import java.util.Map;
import software.tnb.hyperfoil.validation.generated.ServerVariable;

public class ServerConfiguration {
    private String url;
    private String description;
    private Map<String, ServerVariable> variables;

    public ServerConfiguration(String url, String description, Map<String, ServerVariable> variables) {
        this.url = url;
        this.description = description;
        this.variables = variables;
    }

    public String url(Map<String, String> variables) {
        String urlInner = this.url;
        for (Map.Entry<String, ServerVariable> variable : this.variables.entrySet()) {
            String name = variable.getKey();
            ServerVariable serverVariable = variable.getValue();
            String value = serverVariable.getDefaultValue();
            if (variables != null && variables.containsKey(name)) {
                value = variables.get(name);
                if (serverVariable.getEnumValues().size() > 0 && !serverVariable.getEnumValues().contains(value)) {
                    throw new RuntimeException("The variable " + name + " in the server URL has invalid value " + value + ".");
                }
            }
            urlInner = urlInner.replaceAll("\\{" + name + "\\}", value);
        }
        return urlInner;
    }

    public String getURL() {
        return this.url(null);
    }
}

