/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.hyperfoil.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import okhttp3.OkHttpClient;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.utils.HTTPUtils;
import software.tnb.hyperfoil.validation.generated.ApiClient;
import software.tnb.hyperfoil.validation.generated.ApiException;
import software.tnb.hyperfoil.validation.generated.Configuration;
import software.tnb.hyperfoil.validation.generated.api.DefaultApi;
import software.tnb.hyperfoil.validation.generated.model.Run;

public class HyperfoilValidation {
    private static final Logger LOG = LoggerFactory.getLogger(HyperfoilValidation.class);
    private static final Long WAIT_BENCHMARK_SLEEP_TIME = 1000L;
    private static final ObjectMapper yamlMapper = new YAMLMapper();
    private final DefaultApi defaultApi;

    public HyperfoilValidation(String basePath) {
        ApiClient apiClient = Configuration.getDefaultApiClient();
        apiClient.setBasePath(basePath);
        apiClient.setVerifyingSsl(false);
        this.defaultApi = new DefaultApi(apiClient);
    }

    public void startAndWaitForBenchmark(String benchmark) {
        this.startAndWaitForBenchmark(benchmark, null);
    }

    public void startAndWaitForBenchmark(String benchmark, String applicationUnderTestEndpoint) {
        LOG.info("Add benchmark " + benchmark);
        String benchmarkName = this.addBenchmark(benchmark, applicationUnderTestEndpoint);
        LOG.info("Run benchmark");
        Run run = this.runBenchmark(benchmarkName);
        LOG.info("Run started");
        LOG.info(run.toString());
        this.waitForRun(run);
        LOG.info("Benchmark finished");
        LOG.info(this.getRun(run.getId()).toString());
        LOG.info("Generating report");
        String report = this.generateReport(run);
        Path reportFile = this.saveReportToFile(run, report);
        LOG.info("Report generated " + reportFile.toAbsolutePath());
    }

    private Path saveReportToFile(Run run, String report) {
        try {
            Path destination = Paths.get("target", run.getBenchmark() + "-" + LocalDateTime.now() + ".html");
            software.tnb.common.utils.IOUtils.writeFile((Path)destination, (String)report);
            return destination;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String generateReport(Run run) {
        try {
            return this.getDefaultApi().createReport(run.getId(), null);
        }
        catch (ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String addBenchmark(String benchmarkUri, String applicationUnderTestEndpoint) {
        try {
            String benchmark;
            if (((String)benchmarkUri).startsWith("http:") || ((String)benchmarkUri).startsWith("https:")) {
                HTTPUtils.Response response = HTTPUtils.getInstance((OkHttpClient)HTTPUtils.trustAllSslClient()).get((String)benchmarkUri);
                if (response.getResponseCode() != 200) {
                    throw new RuntimeException("Call to " + (String)benchmarkUri + " failed " + response.getResponseCode() + " " + response.getBody());
                }
                benchmark = response.getBody();
            } else {
                if (!((String)benchmarkUri).startsWith("/")) {
                    benchmarkUri = "/" + (String)benchmarkUri;
                }
                try (InputStream is = this.getClass().getResourceAsStream((String)benchmarkUri);){
                    byte[] benchmarkByteArray = IOUtils.toByteArray((InputStream)is);
                    benchmark = new String(benchmarkByteArray);
                }
            }
            ObjectNode node = (ObjectNode)yamlMapper.readValue(benchmark, ObjectNode.class);
            if (Objects.nonNull(applicationUnderTestEndpoint)) {
                JsonNode httpNode = node.get("http");
                if (httpNode.isObject()) {
                    ((ObjectNode)httpNode).put("host", applicationUnderTestEndpoint);
                } else if (httpNode.isArray()) {
                    throw new RuntimeException("Array node detected for http.host, impossible to distinguish which host should be replaced");
                }
            }
            String hyperfoilYaml = yamlMapper.writeValueAsString((Object)node);
            LOG.info("Using the following hyperfoil yaml");
            LOG.info(hyperfoilYaml);
            String name = node.get("name").asText();
            File tempBenchmarkFile = Files.createTempFile(name, ".yaml", new FileAttribute[0]).toFile();
            yamlMapper.writeValue(tempBenchmarkFile, (Object)node);
            this.getDefaultApi().addBenchmark(null, null, tempBenchmarkFile);
            return name;
        }
        catch (IOException | ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Run getRun(String runId) {
        try {
            return this.getDefaultApi().getRun(runId);
        }
        catch (ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new Run();
        }
    }

    public void waitForRun(Run run) {
        try {
            while (!run.getCompleted().booleanValue()) {
                run = this.getDefaultApi().getRun(run.getId());
                if (LOG.isTraceEnabled()) {
                    LOG.trace(run.toString());
                }
                Thread.sleep(WAIT_BENCHMARK_SLEEP_TIME);
            }
        }
        catch (InterruptedException | ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> listBenchmarks() throws ApiException {
        return this.getDefaultApi().listBenchmarks();
    }

    public Run runBenchmark(String benchmarkName) {
        try {
            if (this.listBenchmarks().size() == 0) {
                throw new RuntimeException("Benchmark not found, execute addBenchmark(...)");
            }
            String benchmark = this.listBenchmarks().stream().filter(n -> n.equals(benchmarkName)).findFirst().orElseThrow(() -> new RuntimeException("Benchmark with name " + benchmarkName + " does not exists"));
            String triggerJob = System.getenv("BUILD_URL") != null ? System.getenv("BUILD_URL") : null;
            return this.getDefaultApi().startBenchmark(benchmark, "TNB - " + benchmark, triggerJob, null, null);
        }
        catch (ApiException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public DefaultApi getDefaultApi() {
        return this.defaultApi;
    }
}

