/*
 * Hyperfoil Controller API
 * Hyperfoil Controller API
 *
 * The version of the OpenAPI document: 0.5
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.tnb.hyperfoil.validation.generated.api;

import com.google.gson.reflect.TypeToken;

import org.apache.commons.io.FilenameUtils;

import software.tnb.hyperfoil.validation.generated.*;
import software.tnb.hyperfoil.validation.generated.model.Histogram;
import software.tnb.hyperfoil.validation.generated.model.RequestStatisticsResponse;
import software.tnb.hyperfoil.validation.generated.model.Run;
import software.tnb.hyperfoil.validation.generated.model.Version;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    private final Map<String, String> wellKnownMimeTypes = Map.of("yaml", "text/vnd.yaml", "yml", "text/vnd.yaml", "json", "application/json");

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for addBenchmark
     *
     * @param ifMatch If we are updating an existing benchmark, expected previous version. (optional)
     * @param storedFilesBenchmark Name of previously uploaded benchmark where extra files should be loaded from during multi-part upload. Usually
     * this is the same benchmark unless it is being renamed. (optional)
     * @param body Benchmark definition. (optional)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 204 </td><td> Benchmark accepted. </td><td>  -  </td></tr>
     * <tr><td> 400 </td><td> Benchmark is invalid. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Unsupported content-type. </td><td>  -  </td></tr>
     * <tr><td> 409 </td><td> Version of benchmark stored on server does not match to the updated version. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call addBenchmarkCall(String ifMatch, String storedFilesBenchmark, File body, final ApiCallback apiBenchmarkCallback)
        throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/benchmark";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (storedFilesBenchmark != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("storedFilesBenchmark", storedFilesBenchmark));
        }

        if (ifMatch != null) {
            localVarHeaderParams.put("if-match", localVarApiClient.parameterToString(ifMatch));
        }

        final String[] localVarAccepts = {

        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "text/uri-list", "text/vnd.yaml", "application/java-serialized-object", "multipart/form-data"
        };

        String benchmarkFileExt = FilenameUtils.getExtension(body.getName());
        final String localVarContentType = wellKnownMimeTypes.containsKey(benchmarkFileExt) ? wellKnownMimeTypes.get(benchmarkFileExt) :
            localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addBenchmarkValidateBeforeCall(String ifMatch, String storedFilesBenchmark, File body,
        final ApiCallback apiBenchmarkCallback)
        throws ApiException {

        okhttp3.Call localVarCall = addBenchmarkCall(ifMatch, storedFilesBenchmark, body, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Add new benchmark definition.
     *
     * @param ifMatch If we are updating an existing benchmark, expected previous version. (optional)
     * @param storedFilesBenchmark Name of previously uploaded benchmark where extra files should be loaded from during multi-part upload. Usually
     * this is the same benchmark unless it is being renamed. (optional)
     * @param body Benchmark definition. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 204 </td><td> Benchmark accepted. </td><td>  -  </td></tr>
     * <tr><td> 400 </td><td> Benchmark is invalid. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Unsupported content-type. </td><td>  -  </td></tr>
     * <tr><td> 409 </td><td> Version of benchmark stored on server does not match to the updated version. </td><td>  -  </td></tr>
     * </table>
     */
    public void addBenchmark(String ifMatch, String storedFilesBenchmark, File body) throws ApiException {
        addBenchmarkWithHttpInfo(ifMatch, storedFilesBenchmark, body);
    }

    /**
     * Add new benchmark definition.
     *
     * @param ifMatch If we are updating an existing benchmark, expected previous version. (optional)
     * @param storedFilesBenchmark Name of previously uploaded benchmark where extra files should be loaded from during multi-part upload. Usually
     * this is the same benchmark unless it is being renamed. (optional)
     * @param body Benchmark definition. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 204 </td><td> Benchmark accepted. </td><td>  -  </td></tr>
     * <tr><td> 400 </td><td> Benchmark is invalid. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Unsupported content-type. </td><td>  -  </td></tr>
     * <tr><td> 409 </td><td> Version of benchmark stored on server does not match to the updated version. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Void> addBenchmarkWithHttpInfo(String ifMatch, String storedFilesBenchmark, File body) throws ApiException {
        okhttp3.Call localVarCall = addBenchmarkValidateBeforeCall(ifMatch, storedFilesBenchmark, body, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Add new benchmark definition. (asynchronously)
     *
     * @param ifMatch If we are updating an existing benchmark, expected previous version. (optional)
     * @param storedFilesBenchmark Name of previously uploaded benchmark where extra files should be loaded from during multi-part upload. Usually
     * this is the same benchmark unless it is being renamed. (optional)
     * @param body Benchmark definition. (optional)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 204 </td><td> Benchmark accepted. </td><td>  -  </td></tr>
     * <tr><td> 400 </td><td> Benchmark is invalid. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Unsupported content-type. </td><td>  -  </td></tr>
     * <tr><td> 409 </td><td> Version of benchmark stored on server does not match to the updated version. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call addBenchmarkAsync(String ifMatch, String storedFilesBenchmark, File body, final ApiCallback<Void> apiBenchmarkCallback)
        throws ApiException {

        okhttp3.Call localVarCall = addBenchmarkValidateBeforeCall(ifMatch, storedFilesBenchmark, body, apiBenchmarkCallback);
        localVarApiClient.executeAsync(localVarCall, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for agentCpu
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run was killed. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call agentCpuCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/agentCpu"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call agentCpuValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling agentCpu(Async)");
        }

        okhttp3.Call localVarCall = agentCpuCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Get agent CPU data
     *
     * @param runId (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run was killed. </td><td>  -  </td></tr>
     * </table>
     */
    public Object agentCpu(String runId) throws ApiException {
        ApiResponse<Object> localVarResp = agentCpuWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Get agent CPU data
     *
     * @param runId (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run was killed. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> agentCpuWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = agentCpuValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get agent CPU data (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run was killed. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call agentCpuAsync(String runId, final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = agentCpuValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for createReport
     *
     * @param runId (required)
     * @param source (optional)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Generated report </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call createReportCall(String runId, String source, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/report"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (source != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("source", source));
        }

        final String[] localVarAccepts = {
            "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createReportValidateBeforeCall(String runId, String source, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling createReport(Async)");
        }

        okhttp3.Call localVarCall = createReportCall(runId, source, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Generate HTML report for this run
     *
     * @param runId (required)
     * @param source (optional)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Generated report </td><td>  -  </td></tr>
     * </table>
     */
    public String createReport(String runId, String source) throws ApiException {
        ApiResponse<String> localVarResp = createReportWithHttpInfo(runId, source);
        return localVarResp.getData();
    }

    /**
     * Generate HTML report for this run
     *
     * @param runId (required)
     * @param source (optional)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Generated report </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<String> createReportWithHttpInfo(String runId, String source) throws ApiException {
        okhttp3.Call localVarCall = createReportValidateBeforeCall(runId, source, null);
        Type localVarReturnType = new TypeToken<String>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Generate HTML report for this run (asynchronously)
     *
     * @param runId (required)
     * @param source (optional)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Generated report </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call createReportAsync(String runId, String source, final ApiCallback<String> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = createReportValidateBeforeCall(runId, source, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<String>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getAgentLog
     *
     * @param agent (required)
     * @param offset (optional, default to 0)
     * @param ifMatch Identifier of the previously downloaded log chunk. (optional)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getAgentLogCall(String agent, Integer offset, String ifMatch, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/log/{agent}"
            .replaceAll("\\{" + "agent" + "\\}", localVarApiClient.escapeString(agent.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (ifMatch != null) {
            localVarHeaderParams.put("if-match", localVarApiClient.parameterToString(ifMatch));
        }

        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAgentLogValidateBeforeCall(String agent, Integer offset, String ifMatch, final ApiCallback apiBenchmarkCallback)
        throws ApiException {

        // verify the required parameter 'agent' is set
        if (agent == null) {
            throw new ApiException("Missing the required parameter 'agent' when calling getAgentLog(Async)");
        }

        okhttp3.Call localVarCall = getAgentLogCall(agent, offset, ifMatch, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Get controller log.
     *
     * @param agent (required)
     * @param offset (optional, default to 0)
     * @param ifMatch Identifier of the previously downloaded log chunk. (optional)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public String getAgentLog(String agent, Integer offset, String ifMatch) throws ApiException {
        ApiResponse<String> localVarResp = getAgentLogWithHttpInfo(agent, offset, ifMatch);
        return localVarResp.getData();
    }

    /**
     * Get controller log.
     *
     * @param agent (required)
     * @param offset (optional, default to 0)
     * @param ifMatch Identifier of the previously downloaded log chunk. (optional)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<String> getAgentLogWithHttpInfo(String agent, Integer offset, String ifMatch) throws ApiException {
        okhttp3.Call localVarCall = getAgentLogValidateBeforeCall(agent, offset, ifMatch, null);
        Type localVarReturnType = new TypeToken<String>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get controller log. (asynchronously)
     *
     * @param agent (required)
     * @param offset (optional, default to 0)
     * @param ifMatch Identifier of the previously downloaded log chunk. (optional)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getAgentLogAsync(String agent, Integer offset, String ifMatch, final ApiCallback<String> apiBenchmarkCallback)
        throws ApiException {

        okhttp3.Call localVarCall = getAgentLogValidateBeforeCall(agent, offset, ifMatch, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<String>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getAllStats
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getAllStatsCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/stats/all"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/zip", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllStatsValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getAllStats(Async)");
        }

        okhttp3.Call localVarCall = getAllStatsCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Get complete statistics from the run.
     * This can be invoked only after the run completes. Provides exported statistics either as ZIP file with CSV files or as JSON object.
     *
     * @param runId (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public File getAllStats(String runId) throws ApiException {
        ApiResponse<File> localVarResp = getAllStatsWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Get complete statistics from the run.
     * This can be invoked only after the run completes. Provides exported statistics either as ZIP file with CSV files or as JSON object.
     *
     * @param runId (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<File> getAllStatsWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getAllStatsValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<File>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get complete statistics from the run. (asynchronously)
     * This can be invoked only after the run completes. Provides exported statistics either as ZIP file with CSV files or as JSON object.
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getAllStatsAsync(String runId, final ApiCallback<File> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getAllStatsValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<File>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getAllStatsCsv
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getAllStatsCsvCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/stats/all/csv"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/zip"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllStatsCsvValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getAllStatsCsv(Async)");
        }

        okhttp3.Call localVarCall = getAllStatsCsvCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Get complete statistics from the run.
     * This can be invoked only after the run completes. Provides exported statistics as ZIP file with CSV files
     *
     * @param runId (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public Object getAllStatsCsv(String runId) throws ApiException {
        ApiResponse<Object> localVarResp = getAllStatsCsvWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Get complete statistics from the run.
     * This can be invoked only after the run completes. Provides exported statistics as ZIP file with CSV files
     *
     * @param runId (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> getAllStatsCsvWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getAllStatsCsvValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get complete statistics from the run. (asynchronously)
     * This can be invoked only after the run completes. Provides exported statistics as ZIP file with CSV files
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getAllStatsCsvAsync(String runId, final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getAllStatsCsvValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getAllStatsJson
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getAllStatsJsonCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/stats/all/json"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllStatsJsonValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getAllStatsJson(Async)");
        }

        okhttp3.Call localVarCall = getAllStatsJsonCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Get complete statistics from the run.
     * This can be invoked only after the run completes. Provides exported statistics as JSON object.
     *
     * @param runId (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public Object getAllStatsJson(String runId) throws ApiException {
        ApiResponse<Object> localVarResp = getAllStatsJsonWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Get complete statistics from the run.
     * This can be invoked only after the run completes. Provides exported statistics as JSON object.
     *
     * @param runId (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> getAllStatsJsonWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getAllStatsJsonValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get complete statistics from the run. (asynchronously)
     * This can be invoked only after the run completes. Provides exported statistics as JSON object.
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getAllStatsJsonAsync(String runId, final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getAllStatsJsonValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getBenchmark
     *
     * @param name (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Existing benchmark definition. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getBenchmarkCall(String name, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/benchmark/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/vnd.yaml", "application/java-serialized-object"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBenchmarkValidateBeforeCall(String name, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getBenchmark(Async)");
        }

        okhttp3.Call localVarCall = getBenchmarkCall(name, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Retrieve existing benchmark.
     *
     * @param name (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Existing benchmark definition. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public Object getBenchmark(String name) throws ApiException {
        ApiResponse<Object> localVarResp = getBenchmarkWithHttpInfo(name);
        return localVarResp.getData();
    }

    /**
     * Retrieve existing benchmark.
     *
     * @param name (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Existing benchmark definition. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> getBenchmarkWithHttpInfo(String name) throws ApiException {
        okhttp3.Call localVarCall = getBenchmarkValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve existing benchmark. (asynchronously)
     *
     * @param name (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Existing benchmark definition. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getBenchmarkAsync(String name, final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getBenchmarkValidateBeforeCall(name, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getBenchmarkFiles
     *
     * @param name (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> List of files </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getBenchmarkFilesCall(String name, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/benchmark/{name}/files"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "multipart/form-data"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBenchmarkFilesValidateBeforeCall(String name, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getBenchmarkFiles(Async)");
        }

        okhttp3.Call localVarCall = getBenchmarkFilesCall(name, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Get data files for the benchmark
     *
     * @param name (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> List of files </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public Object getBenchmarkFiles(String name) throws ApiException {
        ApiResponse<Object> localVarResp = getBenchmarkFilesWithHttpInfo(name);
        return localVarResp.getData();
    }

    /**
     * Get data files for the benchmark
     *
     * @param name (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> List of files </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> getBenchmarkFilesWithHttpInfo(String name) throws ApiException {
        okhttp3.Call localVarCall = getBenchmarkFilesValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get data files for the benchmark (asynchronously)
     *
     * @param name (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> List of files </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getBenchmarkFilesAsync(String name, final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getBenchmarkFilesValidateBeforeCall(name, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getBenchmarkForRun
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getBenchmarkForRunCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/benchmark"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/vnd.yaml", "application/java-serialized-object"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBenchmarkForRunValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getBenchmarkForRun(Async)");
        }

        okhttp3.Call localVarCall = getBenchmarkForRunCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Benchmark used for given run.
     *
     * @param runId (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public Object getBenchmarkForRun(String runId) throws ApiException {
        ApiResponse<Object> localVarResp = getBenchmarkForRunWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Benchmark used for given run.
     *
     * @param runId (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> getBenchmarkForRunWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getBenchmarkForRunValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Benchmark used for given run. (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getBenchmarkForRunAsync(String runId, final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getBenchmarkForRunValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getBenchmarkStructure
     *
     * @param name (required)
     * @param maxCollectionSize (optional, default to 20)
     * @param templateParam Template parameters in format KEY&#x3D;VALUE for resolving benchmark without running that. (optional)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark structure. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getBenchmarkStructureCall(String name, Integer maxCollectionSize, List<String> templateParam,
        final ApiCallback apiBenchmarkCallback)
        throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/benchmark/{name}/structure"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (maxCollectionSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxCollectionSize", maxCollectionSize));
        }

        if (templateParam != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "templateParam", templateParam));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBenchmarkStructureValidateBeforeCall(String name, Integer maxCollectionSize, List<String> templateParam,
        final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getBenchmarkStructure(Async)");
        }

        okhttp3.Call localVarCall = getBenchmarkStructureCall(name, maxCollectionSize, templateParam, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Inspect the rendered structure of the benchmark.
     *
     * @param name (required)
     * @param maxCollectionSize (optional, default to 20)
     * @param templateParam Template parameters in format KEY&#x3D;VALUE for resolving benchmark without running that. (optional)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark structure. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public Object getBenchmarkStructure(String name, Integer maxCollectionSize, List<String> templateParam) throws ApiException {
        ApiResponse<Object> localVarResp = getBenchmarkStructureWithHttpInfo(name, maxCollectionSize, templateParam);
        return localVarResp.getData();
    }

    /**
     * Inspect the rendered structure of the benchmark.
     *
     * @param name (required)
     * @param maxCollectionSize (optional, default to 20)
     * @param templateParam Template parameters in format KEY&#x3D;VALUE for resolving benchmark without running that. (optional)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark structure. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> getBenchmarkStructureWithHttpInfo(String name, Integer maxCollectionSize, List<String> templateParam)
        throws ApiException {
        okhttp3.Call localVarCall = getBenchmarkStructureValidateBeforeCall(name, maxCollectionSize, templateParam, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Inspect the rendered structure of the benchmark. (asynchronously)
     *
     * @param name (required)
     * @param maxCollectionSize (optional, default to 20)
     * @param templateParam Template parameters in format KEY&#x3D;VALUE for resolving benchmark without running that. (optional)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark structure. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Benchmark is not defined. </td><td>  -  </td></tr>
     * <tr><td> 406 </td><td> Benchmark does not preserve the original source. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getBenchmarkStructureAsync(String name, Integer maxCollectionSize, List<String> templateParam,
        final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getBenchmarkStructureValidateBeforeCall(name, maxCollectionSize, templateParam, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getControllerLog
     *
     * @param offset (optional, default to 0)
     * @param ifMatch Identifier of the previously downloaded log chunk. (optional)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getControllerLogCall(Integer offset, String ifMatch, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/log";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (ifMatch != null) {
            localVarHeaderParams.put("if-match", localVarApiClient.parameterToString(ifMatch));
        }

        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
            localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getControllerLogValidateBeforeCall(Integer offset, String ifMatch, final ApiCallback apiBenchmarkCallback)
        throws ApiException {

        okhttp3.Call localVarCall = getControllerLogCall(offset, ifMatch, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Get controller log.
     *
     * @param offset (optional, default to 0)
     * @param ifMatch Identifier of the previously downloaded log chunk. (optional)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public String getControllerLog(Integer offset, String ifMatch) throws ApiException {
        ApiResponse<String> localVarResp = getControllerLogWithHttpInfo(offset, ifMatch);
        return localVarResp.getData();
    }

    /**
     * Get controller log.
     *
     * @param offset (optional, default to 0)
     * @param ifMatch Identifier of the previously downloaded log chunk. (optional)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<String> getControllerLogWithHttpInfo(Integer offset, String ifMatch) throws ApiException {
        okhttp3.Call localVarCall = getControllerLogValidateBeforeCall(offset, ifMatch, null);
        Type localVarReturnType = new TypeToken<String>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get controller log. (asynchronously)
     *
     * @param offset (optional, default to 0)
     * @param ifMatch Identifier of the previously downloaded log chunk. (optional)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getControllerLogAsync(Integer offset, String ifMatch, final ApiCallback<String> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getControllerLogValidateBeforeCall(offset, ifMatch, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<String>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getHistogramStats
     *
     * @param runId (required)
     * @param phase (required)
     * @param stepId (required)
     * @param metric (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getHistogramStatsCall(String runId, String phase, Integer stepId, String metric, final ApiCallback apiBenchmarkCallback)
        throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/stats/histogram"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (phase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("phase", phase));
        }

        if (stepId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stepId", stepId));
        }

        if (metric != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("metric", metric));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
            localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistogramStatsValidateBeforeCall(String runId, String phase, Integer stepId, String metric,
        final ApiCallback apiBenchmarkCallback)
        throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getHistogramStats(Async)");
        }

        // verify the required parameter 'phase' is set
        if (phase == null) {
            throw new ApiException("Missing the required parameter 'phase' when calling getHistogramStats(Async)");
        }

        // verify the required parameter 'stepId' is set
        if (stepId == null) {
            throw new ApiException("Missing the required parameter 'stepId' when calling getHistogramStats(Async)");
        }

        // verify the required parameter 'metric' is set
        if (metric == null) {
            throw new ApiException("Missing the required parameter 'metric' when calling getHistogramStats(Async)");
        }

        okhttp3.Call localVarCall = getHistogramStatsCall(runId, phase, stepId, metric, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Retrieve histogram for given metric.
     *
     * @param runId (required)
     * @param phase (required)
     * @param stepId (required)
     * @param metric (required)
     * @return List&lt;Histogram&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public List<Histogram> getHistogramStats(String runId, String phase, Integer stepId, String metric) throws ApiException {
        ApiResponse<List<Histogram>> localVarResp = getHistogramStatsWithHttpInfo(runId, phase, stepId, metric);
        return localVarResp.getData();
    }

    /**
     * Retrieve histogram for given metric.
     *
     * @param runId (required)
     * @param phase (required)
     * @param stepId (required)
     * @param metric (required)
     * @return ApiResponse&lt;List&lt;Histogram&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<List<Histogram>> getHistogramStatsWithHttpInfo(String runId, String phase, Integer stepId, String metric) throws ApiException {
        okhttp3.Call localVarCall = getHistogramStatsValidateBeforeCall(runId, phase, stepId, metric, null);
        Type localVarReturnType = new TypeToken<List<Histogram>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve histogram for given metric. (asynchronously)
     *
     * @param runId (required)
     * @param phase (required)
     * @param stepId (required)
     * @param metric (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getHistogramStatsAsync(String runId, String phase, Integer stepId, String metric,
        final ApiCallback<List<Histogram>> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getHistogramStatsValidateBeforeCall(runId, phase, stepId, metric, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<List<Histogram>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getRecentConnections
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getRecentConnectionsCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/connections/recent"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRecentConnectionsValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getRecentConnections(Async)");
        }

        okhttp3.Call localVarCall = getRecentConnectionsCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Actual numbers of connections for each host:port
     *
     * @param runId (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public Object getRecentConnections(String runId) throws ApiException {
        ApiResponse<Object> localVarResp = getRecentConnectionsWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Actual numbers of connections for each host:port
     *
     * @param runId (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> getRecentConnectionsWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getRecentConnectionsValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Actual numbers of connections for each host:port (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getRecentConnectionsAsync(String runId, final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getRecentConnectionsValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getRecentSessions
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getRecentSessionsCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/sessions/recent"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRecentSessionsValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getRecentSessions(Async)");
        }

        okhttp3.Call localVarCall = getRecentSessionsCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Actual numbers of active sessions in each phase
     *
     * @param runId (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public Object getRecentSessions(String runId) throws ApiException {
        ApiResponse<Object> localVarResp = getRecentSessionsWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Actual numbers of active sessions in each phase
     *
     * @param runId (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> getRecentSessionsWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getRecentSessionsValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Actual numbers of active sessions in each phase (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getRecentSessionsAsync(String runId, final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getRecentSessionsValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getRecentStats
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getRecentStatsCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/stats/recent"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRecentStatsValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getRecentStats(Async)");
        }

        okhttp3.Call localVarCall = getRecentStatsCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Actual statistics from last 5 seconds of run.
     *
     * @param runId (required)
     * @return RequestStatisticsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public RequestStatisticsResponse getRecentStats(String runId) throws ApiException {
        ApiResponse<RequestStatisticsResponse> localVarResp = getRecentStatsWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Actual statistics from last 5 seconds of run.
     *
     * @param runId (required)
     * @return ApiResponse&lt;RequestStatisticsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<RequestStatisticsResponse> getRecentStatsWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getRecentStatsValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<RequestStatisticsResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Actual statistics from last 5 seconds of run. (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getRecentStatsAsync(String runId, final ApiCallback<RequestStatisticsResponse> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getRecentStatsValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<RequestStatisticsResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getRun
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run information. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getRunCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRunValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getRun(Async)");
        }

        okhttp3.Call localVarCall = getRunCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Get info about run.
     *
     * @param runId (required)
     * @return Run
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run information. </td><td>  -  </td></tr>
     * </table>
     */
    public Run getRun(String runId) throws ApiException {
        ApiResponse<Run> localVarResp = getRunWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Get info about run.
     *
     * @param runId (required)
     * @return ApiResponse&lt;Run&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run information. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Run> getRunWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getRunValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<Run>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get info about run. (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run information. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getRunAsync(String runId, final ApiCallback<Run> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getRunValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Run>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getRunFile
     *
     * @param runId (required)
     * @param runFileName (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully </td><td>  -  </td></tr>
     * <tr><td> 403 </td><td> File is not within the run directory </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> File not found </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getRunFileCall(String runId, String runFileName, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/file"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (runFileName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("file", runFileName));
        }

        final String[] localVarAccepts = {
            "application/octet-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRunFileValidateBeforeCall(String runId, String runFileName, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getRunFile(Async)");
        }

        // verify the required parameter 'runFileName' is set
        if (runFileName == null) {
            throw new ApiException("Missing the required parameter 'runFileName' when calling getRunFile(Async)");
        }

        okhttp3.Call localVarCall = getRunFileCall(runId, runFileName, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Retrieve a custom file in the run directory (generated by hooks)
     *
     * @param runId (required)
     * @param runFileName (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully </td><td>  -  </td></tr>
     * <tr><td> 403 </td><td> File is not within the run directory </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> File not found </td><td>  -  </td></tr>
     * </table>
     */
    public File getRunFile(String runId, String runFileName) throws ApiException {
        ApiResponse<File> localVarResp = getRunFileWithHttpInfo(runId, runFileName);
        return localVarResp.getData();
    }

    /**
     * Retrieve a custom file in the run directory (generated by hooks)
     *
     * @param runId (required)
     * @param runFileName (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully </td><td>  -  </td></tr>
     * <tr><td> 403 </td><td> File is not within the run directory </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> File not found </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<File> getRunFileWithHttpInfo(String runId, String runFileName) throws ApiException {
        okhttp3.Call localVarCall = getRunFileValidateBeforeCall(runId, runFileName, null);
        Type localVarReturnType = new TypeToken<File>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve a custom file in the run directory (generated by hooks) (asynchronously)
     *
     * @param runId (required)
     * @param runFileName (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully </td><td>  -  </td></tr>
     * <tr><td> 403 </td><td> File is not within the run directory </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> File not found </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getRunFileAsync(String runId, String runFileName, final ApiCallback<File> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getRunFileValidateBeforeCall(runId, runFileName, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<File>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getToken
     *
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Serving token </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getTokenCall(final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/token";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {

        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTokenValidateBeforeCall(final ApiCallback apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getTokenCall(apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Get authorization token
     * Returns authorization token that can be used instead of credentials with Basic Auth.
     *
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Serving token </td><td>  -  </td></tr>
     * </table>
     */
    public void getToken() throws ApiException {
        getTokenWithHttpInfo();
    }

    /**
     * Get authorization token
     * Returns authorization token that can be used instead of credentials with Basic Auth.
     *
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Serving token </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Void> getTokenWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getTokenValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Get authorization token (asynchronously)
     * Returns authorization token that can be used instead of credentials with Basic Auth.
     *
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Serving token </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getTokenAsync(final ApiCallback<Void> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getTokenValidateBeforeCall(apiBenchmarkCallback);
        localVarApiClient.executeAsync(localVarCall, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getTotalConnections
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getTotalConnectionsCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/connections/total"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTotalConnectionsValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getTotalConnections(Async)");
        }

        okhttp3.Call localVarCall = getTotalConnectionsCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Total number of connections for each host:port
     *
     * @param runId (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public Object getTotalConnections(String runId) throws ApiException {
        ApiResponse<Object> localVarResp = getTotalConnectionsWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Total number of connections for each host:port
     *
     * @param runId (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> getTotalConnectionsWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getTotalConnectionsValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Total number of connections for each host:port (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getTotalConnectionsAsync(String runId, final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getTotalConnectionsValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getTotalSessions
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getTotalSessionsCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/sessions/total"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTotalSessionsValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getTotalSessions(Async)");
        }

        okhttp3.Call localVarCall = getTotalSessionsCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Min/max of active sessions in each phase
     *
     * @param runId (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public Object getTotalSessions(String runId) throws ApiException {
        ApiResponse<Object> localVarResp = getTotalSessionsWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Min/max of active sessions in each phase
     *
     * @param runId (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Object> getTotalSessionsWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getTotalSessionsValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Min/max of active sessions in each phase (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getTotalSessionsAsync(String runId, final ApiCallback<Object> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getTotalSessionsValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Object>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getTotalStats
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getTotalStatsCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/stats/total"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTotalStatsValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getTotalStats(Async)");
        }

        okhttp3.Call localVarCall = getTotalStatsCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Statistics over the whole duration of phases.
     *
     * @param runId (required)
     * @return RequestStatisticsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public RequestStatisticsResponse getTotalStats(String runId) throws ApiException {
        ApiResponse<RequestStatisticsResponse> localVarResp = getTotalStatsWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Statistics over the whole duration of phases.
     *
     * @param runId (required)
     * @return ApiResponse&lt;RequestStatisticsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<RequestStatisticsResponse> getTotalStatsWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getTotalStatsValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<RequestStatisticsResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Statistics over the whole duration of phases. (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getTotalStatsAsync(String runId, final ApiCallback<RequestStatisticsResponse> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getTotalStatsValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<RequestStatisticsResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for getVersion
     *
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getVersionCall(final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/version";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getVersionValidateBeforeCall(final ApiCallback apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getVersionCall(apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Fetch controller version
     *
     * @return Version
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully </td><td>  -  </td></tr>
     * </table>
     */
    public Version getVersion() throws ApiException {
        ApiResponse<Version> localVarResp = getVersionWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Fetch controller version
     *
     * @return ApiResponse&lt;Version&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Version> getVersionWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getVersionValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Version>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Fetch controller version (asynchronously)
     *
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getVersionAsync(final ApiCallback<Version> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = getVersionValidateBeforeCall(apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Version>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for killRun
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run was killed. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call killRunCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/kill"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {

        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call killRunValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling killRun(Async)");
        }

        okhttp3.Call localVarCall = killRunCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Kill this run
     *
     * @param runId (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run was killed. </td><td>  -  </td></tr>
     * </table>
     */
    public void killRun(String runId) throws ApiException {
        killRunWithHttpInfo(runId);
    }

    /**
     * Kill this run
     *
     * @param runId (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run was killed. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Void> killRunWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = killRunValidateBeforeCall(runId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Kill this run (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Run was killed. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call killRunAsync(String runId, final ApiCallback<Void> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = killRunValidateBeforeCall(runId, apiBenchmarkCallback);
        localVarApiClient.executeAsync(localVarCall, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for listAgents
     *
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listAgentsCall(final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/agents";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listAgentsValidateBeforeCall(final ApiCallback apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = listAgentsCall(apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * All agents used (in all runs)
     *
     * @return List&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public List<String> listAgents() throws ApiException {
        ApiResponse<List<String>> localVarResp = listAgentsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * All agents used (in all runs)
     *
     * @return ApiResponse&lt;List&lt;String&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<List<String>> listAgentsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listAgentsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<String>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * All agents used (in all runs) (asynchronously)
     *
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listAgentsAsync(final ApiCallback<List<String>> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = listAgentsValidateBeforeCall(apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<List<String>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for listBenchmarks
     *
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark names. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listBenchmarksCall(final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/benchmark";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listBenchmarksValidateBeforeCall(final ApiCallback apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = listBenchmarksCall(apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * List defined benchmark names.
     *
     * @return List&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark names. </td><td>  -  </td></tr>
     * </table>
     */
    public List<String> listBenchmarks() throws ApiException {
        ApiResponse<List<String>> localVarResp = listBenchmarksWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * List defined benchmark names.
     *
     * @return ApiResponse&lt;List&lt;String&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark names. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<List<String>> listBenchmarksWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listBenchmarksValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<String>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List defined benchmark names. (asynchronously)
     *
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark names. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listBenchmarksAsync(final ApiCallback<List<String>> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = listBenchmarksValidateBeforeCall(apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<List<String>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for listConnections
     *
     * @param runId (required)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listConnectionsCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/connections"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listConnectionsValidateBeforeCall(String runId, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling listConnections(Async)");
        }

        okhttp3.Call localVarCall = listConnectionsCall(runId, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * List connections in plaintext (for debugging)
     *
     * @param runId (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public String listConnections(String runId) throws ApiException {
        ApiResponse<String> localVarResp = listConnectionsWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * List connections in plaintext (for debugging)
     *
     * @param runId (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<String> listConnectionsWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = listConnectionsValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<String>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List connections in plaintext (for debugging) (asynchronously)
     *
     * @param runId (required)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listConnectionsAsync(String runId, final ApiCallback<String> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = listConnectionsValidateBeforeCall(runId, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<String>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for listRuns
     *
     * @param details (optional, default to false)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Here are the runs. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listRunsCall(Boolean details, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (details != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("details", details));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listRunsValidateBeforeCall(Boolean details, final ApiCallback apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = listRunsCall(details, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * List known runs.
     *
     * @param details (optional, default to false)
     * @return Run
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Here are the runs. </td><td>  -  </td></tr>
     * </table>
     */
    public Run listRuns(Boolean details) throws ApiException {
        ApiResponse<Run> localVarResp = listRunsWithHttpInfo(details);
        return localVarResp.getData();
    }

    /**
     * List known runs.
     *
     * @param details (optional, default to false)
     * @return ApiResponse&lt;Run&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Here are the runs. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Run> listRunsWithHttpInfo(Boolean details) throws ApiException {
        okhttp3.Call localVarCall = listRunsValidateBeforeCall(details, null);
        Type localVarReturnType = new TypeToken<Run>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List known runs. (asynchronously)
     *
     * @param details (optional, default to false)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Here are the runs. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listRunsAsync(Boolean details, final ApiCallback<Run> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = listRunsValidateBeforeCall(details, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Run>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for listSessions
     *
     * @param runId (required)
     * @param inactive (optional, default to false)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listSessionsCall(String runId, Boolean inactive, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/run/{runId}/sessions"
            .replaceAll("\\{" + "runId" + "\\}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (inactive != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inactive", inactive));
        }

        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSessionsValidateBeforeCall(String runId, Boolean inactive, final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling listSessions(Async)");
        }

        okhttp3.Call localVarCall = listSessionsCall(runId, inactive, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * List sessions in plaintext (for debugging)
     *
     * @param runId (required)
     * @param inactive (optional, default to false)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public String listSessions(String runId, Boolean inactive) throws ApiException {
        ApiResponse<String> localVarResp = listSessionsWithHttpInfo(runId, inactive);
        return localVarResp.getData();
    }

    /**
     * List sessions in plaintext (for debugging)
     *
     * @param runId (required)
     * @param inactive (optional, default to false)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<String> listSessionsWithHttpInfo(String runId, Boolean inactive) throws ApiException {
        okhttp3.Call localVarCall = listSessionsValidateBeforeCall(runId, inactive, null);
        Type localVarReturnType = new TypeToken<String>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List sessions in plaintext (for debugging) (asynchronously)
     *
     * @param runId (required)
     * @param inactive (optional, default to false)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Retrieved successfully. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listSessionsAsync(String runId, Boolean inactive, final ApiCallback<String> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = listSessionsValidateBeforeCall(runId, inactive, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<String>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for listTemplates
     *
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark template names. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listTemplatesCall(final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/template";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTemplatesValidateBeforeCall(final ApiCallback apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = listTemplatesCall(apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * List defined template names.
     *
     * @return List&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark template names. </td><td>  -  </td></tr>
     * </table>
     */
    public List<String> listTemplates() throws ApiException {
        ApiResponse<List<String>> localVarResp = listTemplatesWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * List defined template names.
     *
     * @return ApiResponse&lt;List&lt;String&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark template names. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<List<String>> listTemplatesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listTemplatesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<String>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List defined template names. (asynchronously)
     *
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Benchmark template names. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call listTemplatesAsync(final ApiCallback<List<String>> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = listTemplatesValidateBeforeCall(apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<List<String>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for openApi
     *
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> This OpenAPI 3 definition </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call openApiCall(final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/openapi";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/vnd.yaml"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call openApiValidateBeforeCall(final ApiCallback apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = openApiCall(apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Serve this OpenAPI 3 definition.
     *
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> This OpenAPI 3 definition </td><td>  -  </td></tr>
     * </table>
     */
    public File openApi() throws ApiException {
        ApiResponse<File> localVarResp = openApiWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Serve this OpenAPI 3 definition.
     *
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> This OpenAPI 3 definition </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<File> openApiWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = openApiValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<File>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Serve this OpenAPI 3 definition. (asynchronously)
     *
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> This OpenAPI 3 definition </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call openApiAsync(final ApiCallback<File> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = openApiValidateBeforeCall(apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<File>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for shutdown
     *
     * @param force (optional, default to false)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Shutting down </td><td>  -  </td></tr>
     * <tr><td> 403 </td><td> Some runs are in progress and force&#x3D;false </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call shutdownCall(Boolean force, final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/shutdown";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        final String[] localVarAccepts = {

        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call shutdownValidateBeforeCall(Boolean force, final ApiCallback apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = shutdownCall(force, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Shutdown controller
     *
     * @param force (optional, default to false)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Shutting down </td><td>  -  </td></tr>
     * <tr><td> 403 </td><td> Some runs are in progress and force&#x3D;false </td><td>  -  </td></tr>
     * </table>
     */
    public void shutdown(Boolean force) throws ApiException {
        shutdownWithHttpInfo(force);
    }

    /**
     * Shutdown controller
     *
     * @param force (optional, default to false)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Shutting down </td><td>  -  </td></tr>
     * <tr><td> 403 </td><td> Some runs are in progress and force&#x3D;false </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Void> shutdownWithHttpInfo(Boolean force) throws ApiException {
        okhttp3.Call localVarCall = shutdownValidateBeforeCall(force, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Shutdown controller (asynchronously)
     *
     * @param force (optional, default to false)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> Shutting down </td><td>  -  </td></tr>
     * <tr><td> 403 </td><td> Some runs are in progress and force&#x3D;false </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call shutdownAsync(Boolean force, final ApiCallback<Void> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = shutdownValidateBeforeCall(force, apiBenchmarkCallback);
        localVarApiClient.executeAsync(localVarCall, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Build call for startBenchmark
     *
     * @param name (required)
     * @param desc Run description (optional)
     * @param xTriggerJob URL of CI job that triggers the run. (optional)
     * @param runId Run ID of run that was already requested but not started. (optional)
     * @param templateParam Template parameter in format KEY&#x3D;VALUE (optional)
     * @param apiBenchmarkCallback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 202 </td><td> Run was successfully started. </td><td>  -  </td></tr>
     * <tr><td> 301 </td><td> Run is requested but it must be started from CI. </td><td>  * Location - URL that should be hit to start the CI job.
     * <br>  * x-run-id - Generated run ID. <br>  </td></tr>
     * <tr><td> 403 </td><td> There is an ongoing run. Try later. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Requested benchmark is not defined. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call startBenchmarkCall(String name, String desc, String xTriggerJob, String runId, List<String> templateParam,
        final ApiCallback apiBenchmarkCallback) throws ApiException {
        String basePath = null;

        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/benchmark/{name}/start"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (desc != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("desc", desc));
        }

        if (runId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("runId", runId));
        }

        if (templateParam != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "templateParam", templateParam));
        }

        if (xTriggerJob != null) {
            localVarHeaderParams.put("x-trigger-job", localVarApiClient.parameterToString(xTriggerJob));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody,
            localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, apiBenchmarkCallback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call startBenchmarkValidateBeforeCall(String name, String desc, String xTriggerJob, String runId, List<String> templateParam,
        final ApiCallback apiBenchmarkCallback) throws ApiException {

        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling startBenchmark(Async)");
        }

        okhttp3.Call localVarCall = startBenchmarkCall(name, desc, xTriggerJob, runId, templateParam, apiBenchmarkCallback);
        return localVarCall;
    }

    /**
     * Start a new run of this benchmark.
     *
     * @param name (required)
     * @param desc Run description (optional)
     * @param xTriggerJob URL of CI job that triggers the run. (optional)
     * @param runId Run ID of run that was already requested but not started. (optional)
     * @param templateParam Template parameter in format KEY&#x3D;VALUE (optional)
     * @return Run
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 202 </td><td> Run was successfully started. </td><td>  -  </td></tr>
     * <tr><td> 301 </td><td> Run is requested but it must be started from CI. </td><td>  * Location - URL that should be hit to start the CI job.
     * <br>  * x-run-id - Generated run ID. <br>  </td></tr>
     * <tr><td> 403 </td><td> There is an ongoing run. Try later. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Requested benchmark is not defined. </td><td>  -  </td></tr>
     * </table>
     */
    public Run startBenchmark(String name, String desc, String xTriggerJob, String runId, List<String> templateParam) throws ApiException {
        ApiResponse<Run> localVarResp = startBenchmarkWithHttpInfo(name, desc, xTriggerJob, runId, templateParam);
        return localVarResp.getData();
    }

    /**
     * Start a new run of this benchmark.
     *
     * @param name (required)
     * @param desc Run description (optional)
     * @param xTriggerJob URL of CI job that triggers the run. (optional)
     * @param runId Run ID of run that was already requested but not started. (optional)
     * @param templateParam Template parameter in format KEY&#x3D;VALUE (optional)
     * @return ApiResponse&lt;Run&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 202 </td><td> Run was successfully started. </td><td>  -  </td></tr>
     * <tr><td> 301 </td><td> Run is requested but it must be started from CI. </td><td>  * Location - URL that should be hit to start the CI job.
     * <br>  * x-run-id - Generated run ID. <br>  </td></tr>
     * <tr><td> 403 </td><td> There is an ongoing run. Try later. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Requested benchmark is not defined. </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<Run> startBenchmarkWithHttpInfo(String name, String desc, String xTriggerJob, String runId, List<String> templateParam)
        throws ApiException {
        okhttp3.Call localVarCall = startBenchmarkValidateBeforeCall(name, desc, xTriggerJob, runId, templateParam, null);
        Type localVarReturnType = new TypeToken<Run>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Start a new run of this benchmark. (asynchronously)
     *
     * @param name (required)
     * @param desc Run description (optional)
     * @param xTriggerJob URL of CI job that triggers the run. (optional)
     * @param runId Run ID of run that was already requested but not started. (optional)
     * @param templateParam Template parameter in format KEY&#x3D;VALUE (optional)
     * @param apiBenchmarkCallback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 202 </td><td> Run was successfully started. </td><td>  -  </td></tr>
     * <tr><td> 301 </td><td> Run is requested but it must be started from CI. </td><td>  * Location - URL that should be hit to start the CI job.
     * <br>  * x-run-id - Generated run ID. <br>  </td></tr>
     * <tr><td> 403 </td><td> There is an ongoing run. Try later. </td><td>  -  </td></tr>
     * <tr><td> 404 </td><td> Requested benchmark is not defined. </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call startBenchmarkAsync(String name, String desc, String xTriggerJob, String runId, List<String> templateParam,
        final ApiCallback<Run> apiBenchmarkCallback) throws ApiException {

        okhttp3.Call localVarCall = startBenchmarkValidateBeforeCall(name, desc, xTriggerJob, runId, templateParam, apiBenchmarkCallback);
        Type localVarReturnType = new TypeToken<Run>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, apiBenchmarkCallback);
        return localVarCall;
    }
}
