/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.storage.service;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auto.service.AutoService;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import io.fabric8.kubernetes.client.utils.Base64;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.service.Service;
import software.tnb.google.cloud.common.account.GoogleCloudAccount;
import software.tnb.google.storage.validation.GoogleStorageValidation;

@AutoService(value={GoogleStorage.class})
public class GoogleStorage
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleStorage.class);
    private GoogleCloudAccount account;
    private Storage client;
    private GoogleStorageValidation validation;

    public GoogleCloudAccount account() {
        if (this.account == null) {
            this.account = (GoogleCloudAccount)AccountFactory.create(GoogleCloudAccount.class);
        }
        return this.account;
    }

    protected Storage client() {
        if (this.client == null) {
            LOG.debug("Creating new Google Storage client");
            try {
                String decodedJson = new String(Base64.decode((String)this.account().serviceAccountKey()));
                this.client = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)IOUtils.toInputStream((String)decodedJson, (String)"UTF-8")))).build().getService();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create new Google Storage client", e);
            }
        }
        return this.client;
    }

    public GoogleStorageValidation validation() {
        return this.validation;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        LOG.debug("Creating new Google Storage validation");
        this.validation = new GoogleStorageValidation(this.client());
    }
}

