/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.storage.validation;

import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.utils.WaitUtils;

public class GoogleStorageValidation {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleStorageValidation.class);
    private final Storage client;

    public GoogleStorageValidation(Storage client) {
        this.client = client;
    }

    public void createBucket(String bucketName) {
        this.createBucket(bucketName, "us");
    }

    public void createBucket(String bucketName, String location) {
        LOG.info("Creating bucket \"{}\" in region \"{}\"", (Object)bucketName, (Object)location);
        this.client.create(BucketInfo.newBuilder((String)bucketName).setLocation(location).build(), new Storage.BucketTargetOption[0]);
    }

    public void createFile(String bucketName, String fileName, String content) {
        LOG.info("Creating a new file \"{}\" with content \"{}\" in \"{}\" bucket", new Object[]{fileName, content, bucketName});
        this.client.create(BlobInfo.newBuilder((String)bucketName, (String)fileName).build(), content.getBytes(), new Storage.BlobTargetOption[0]);
    }

    public void uploadFile(String bucketName, Path file) {
        try {
            LOG.info("Uploading file \"{}\" to \"{}\" bucket", (Object)file.toAbsolutePath(), (Object)bucketName);
            this.client.create(BlobInfo.newBuilder((String)bucketName, (String)file.getFileName().toString()).build(), Files.readAllBytes(file), new Storage.BlobTargetOption[0]);
            WaitUtils.waitFor(() -> this.listFiles(bucketName).contains(file.getFileName().toString()), (String)("Waiting until the file " + file.getFileName() + " is present in bucket " + bucketName));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read file bytes", e);
        }
    }

    public void deleteBucket(String bucketName) {
        block2: {
            LOG.info("Deleting bucket \"{}\"", (Object)bucketName);
            try {
                this.listFiles(bucketName).forEach(f -> this.deleteFile(bucketName, (String)f));
                this.client.delete(bucketName, new Storage.BucketSourceOption[0]);
            }
            catch (StorageException e) {
                if (e.getMessage().contains("bucket does not exist")) break block2;
                throw e;
            }
        }
    }

    public List<String> listFiles(String bucketName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        this.client.list(bucketName, new Storage.BlobListOption[0]).iterateAll().forEach(b -> fileNames.add(b.getBlobId().getName()));
        return fileNames;
    }

    public String getFileContent(String bucketName, String fileName) {
        return new String(this.client.readAllBytes(bucketName, fileName, new Storage.BlobSourceOption[0]));
    }

    public void deleteFile(String bucketName, String fileName) {
        LOG.info("Deleting file \"{}\" in bucket \"{}\"", (Object)fileName, (Object)bucketName);
        this.client.delete(BlobId.of((String)bucketName, (String)fileName));
    }
}

