/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.cloud.pubsub.validation;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubValidation {
    private static final Logger LOG = LoggerFactory.getLogger(PubSubValidation.class);
    private TopicAdminClient topicAdminClient;
    private SubscriptionAdminClient subscriptionAdminClient;
    private String projectId;
    private CredentialsProvider credsProvider;

    public PubSubValidation(TopicAdminClient topicAdminClient, SubscriptionAdminClient subscriptionAdminClient, CredentialsProvider credsProvider, String projectId) {
        this.topicAdminClient = topicAdminClient;
        this.subscriptionAdminClient = subscriptionAdminClient;
        this.projectId = projectId;
        this.credsProvider = credsProvider;
    }

    public Topic createNewTopic(String topicId) {
        Topic topic = this.topicAdminClient.createTopic(TopicName.of((String)this.projectId, (String)topicId));
        LOG.info("Created google pubsub topic: " + topic.getName());
        return topic;
    }

    public void deleteTopic(String topicId) {
        this.topicAdminClient.deleteTopic(TopicName.of((String)this.projectId, (String)topicId));
        LOG.info("Deleted google pubsub topic: " + topicId);
    }

    public Subscription createNewSubscription(String subscriptionId, String topicId) {
        SubscriptionName subscriptionName = SubscriptionName.of((String)this.projectId, (String)subscriptionId);
        TopicName topicName = TopicName.of((String)this.projectId, (String)topicId);
        Subscription subscription = this.subscriptionAdminClient.createSubscription(subscriptionName, topicName, PushConfig.getDefaultInstance(), 10);
        LOG.info("Created google pubsub subscription: " + subscription.getName());
        return subscription;
    }

    public void deleteSubscription(String subscriptionId) {
        this.subscriptionAdminClient.deleteSubscription(SubscriptionName.of((String)this.projectId, (String)subscriptionId));
        LOG.info("Deleted google pubsub subscription: " + subscriptionId);
    }

    public void publishMessage(String topicId, String message) {
        Publisher publisher = null;
        try {
            publisher = Publisher.newBuilder((TopicName)TopicName.of((String)this.projectId, (String)topicId)).setCredentialsProvider(this.credsProvider).build();
            ByteString data = ByteString.copyFromUtf8((String)message);
            PubsubMessage pubsubMessage = PubsubMessage.newBuilder().setData(data).build();
            ApiFuture messageIdFuture = publisher.publish(pubsubMessage);
            if (!((String)messageIdFuture.get()).isEmpty()) {
                LOG.info("Published message {} into topic {}", (Object)message, (Object)topicId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to publish message to topic", e);
        }
        finally {
            if (publisher != null) {
                publisher.shutdown();
                try {
                    publisher.awaitTermination(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Unable to terminate publisher", e);
                }
            }
        }
    }

    public List<PubsubMessage> receiveMessageFor(int seconds, String subscriptionId) {
        ProjectSubscriptionName subscriptionName = ProjectSubscriptionName.of((String)this.projectId, (String)subscriptionId);
        ArrayList<PubsubMessage> messageList = new ArrayList<PubsubMessage>();
        MessageReceiver receiver = (message, consumer) -> {
            messageList.add(message);
            consumer.ack();
        };
        Subscriber subscriber = null;
        try {
            subscriber = Subscriber.newBuilder((ProjectSubscriptionName)subscriptionName, (MessageReceiver)receiver).setCredentialsProvider(this.credsProvider).build();
            subscriber.startAsync().awaitRunning();
            LOG.info("Listening for messages on %s:\n", (Object)subscriptionName.toString());
            subscriber.awaitTerminated((long)seconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            subscriber.stopAsync();
        }
        return messageList;
    }
}

