/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.cloud.pubsub.service;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auto.service.AutoService;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.Accounts;
import software.tnb.common.service.Service;
import software.tnb.google.cloud.common.account.GoogleCloudAccount;
import software.tnb.google.cloud.pubsub.validation.PubSubValidation;

@AutoService(value={GooglePubSub.class})
public class GooglePubSub
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(GooglePubSub.class);
    private GoogleCloudAccount account;
    private PubSubValidation validation;
    private TopicAdminClient topicAdminClient;
    private SubscriptionAdminClient subscriptionAdminClient;

    public GoogleCloudAccount account() {
        if (this.account == null) {
            this.account = (GoogleCloudAccount)Accounts.get(GoogleCloudAccount.class);
        }
        return this.account;
    }

    protected TopicAdminClient topicAdminClient() throws IOException {
        LOG.debug("Creating new Google cloud topic admin client");
        TopicAdminSettings topicAdminSettings = ((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider())).build();
        return TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);
    }

    protected SubscriptionAdminClient subscriptionAdminClient() throws IOException {
        LOG.debug("Creating new Google subscription admin client");
        SubscriptionAdminSettings subscriptionAdminSettings = ((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider())).build();
        return SubscriptionAdminClient.create((SubscriptionAdminSettings)subscriptionAdminSettings);
    }

    private CredentialsProvider credentialsProvider() throws IOException {
        ByteArrayInputStream serviceAccountKey = new ByteArrayInputStream(Base64.getDecoder().decode(this.account().serviceAccountKey()));
        return FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)serviceAccountKey));
    }

    public PubSubValidation validation() {
        return this.validation;
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.topicAdminClient.close();
        this.subscriptionAdminClient.close();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        LOG.debug("Creating new Google PubSub validation");
        this.topicAdminClient = this.topicAdminClient();
        this.subscriptionAdminClient = this.subscriptionAdminClient();
        this.validation = new PubSubValidation(this.topicAdminClient, this.subscriptionAdminClient, this.credentialsProvider(), this.account().projectId());
    }
}

