/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.cloud.pubsub.service;

import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.service.Service;
import software.tnb.google.cloud.common.account.GoogleCloudAccount;
import software.tnb.google.cloud.pubsub.client.PubSubClients;
import software.tnb.google.cloud.pubsub.validation.PubSubValidation;

@AutoService(value={GooglePubSub.class})
public class GooglePubSub
extends Service<GoogleCloudAccount, PubSubClients, PubSubValidation> {
    private static final Logger LOG = LoggerFactory.getLogger(GooglePubSub.class);

    public void afterAll(ExtensionContext extensionContext) {
        if (this.client != null) {
            ((PubSubClients)this.client).close();
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        LOG.debug("Creating new Google PubSub validation");
        this.validation = new PubSubValidation(this.client(), ((GoogleCloudAccount)this.account()).projectId());
    }

    protected PubSubClients client() {
        if (this.client == null) {
            this.client = new PubSubClients((GoogleCloudAccount)this.account());
        }
        return (PubSubClients)this.client;
    }
}

