/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.cloud.pubsub.client;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.google.cloud.common.account.GoogleCloudAccount;

public class PubSubClients {
    private static final Logger LOG = LoggerFactory.getLogger(PubSubClients.class);
    private final GoogleCloudAccount account;
    private final TopicAdminClient topicAdminClient;
    private final SubscriptionAdminClient subscriptionAdminClient;

    public PubSubClients(GoogleCloudAccount account) {
        this.account = account;
        this.topicAdminClient = this.newTopicAdminClient();
        this.subscriptionAdminClient = this.newSubscriptionAdminClient();
    }

    public TopicAdminClient topicAdminClient() {
        return this.topicAdminClient;
    }

    public SubscriptionAdminClient subscriptionAdminClient() {
        return this.subscriptionAdminClient;
    }

    private TopicAdminClient newTopicAdminClient() {
        LOG.debug("Creating new Google cloud topic admin client");
        try {
            TopicAdminSettings topicAdminSettings = ((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider())).build();
            return TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create topic admin client: ", e);
        }
    }

    private SubscriptionAdminClient newSubscriptionAdminClient() {
        LOG.debug("Creating new Google subscription admin client");
        try {
            SubscriptionAdminSettings subscriptionAdminSettings = ((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider())).build();
            return SubscriptionAdminClient.create((SubscriptionAdminSettings)subscriptionAdminSettings);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create subscription admin client: ", e);
        }
    }

    public CredentialsProvider credentialsProvider() {
        ByteArrayInputStream serviceAccountKey = new ByteArrayInputStream(Base64.getDecoder().decode(this.account.serviceAccountKey()));
        try {
            return FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)serviceAccountKey));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to extract service account key: ", e);
        }
    }

    public void close() {
        if (this.topicAdminClient != null) {
            this.topicAdminClient.close();
        }
        if (this.subscriptionAdminClient != null) {
            this.subscriptionAdminClient.close();
        }
    }
}

