/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.mail.validation.model;

import com.google.api.services.gmail.model.Message;
import com.google.api.services.gmail.model.MessagePart;
import com.google.api.services.gmail.model.MessagePartHeader;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class GoogleEmail {
    private String from;
    private List<String> to;
    private List<String> cc;
    private List<String> bcc;
    private String subject;
    private String body;

    public String from() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public List<String> to() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public List<String> cc() {
        return this.cc;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public List<String> bcc() {
        return this.bcc;
    }

    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    public String subject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String body() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public static GoogleEmail fromPayload(Message m) {
        GoogleEmail email = new GoogleEmail();
        Map<String, String> headers = m.getPayload().getHeaders().stream().collect(Collectors.toMap(MessagePartHeader::getName, MessagePartHeader::getValue, (k1, k2) -> k1));
        email.setFrom(headers.get("From"));
        email.setSubject(headers.get("Subject"));
        email.setTo(Arrays.stream(headers.get("To").split(",")).map(String::trim).collect(Collectors.toList()));
        if (headers.get("Cc") != null) {
            email.setCc(Arrays.stream(headers.get("Cc").split(",")).map(String::trim).collect(Collectors.toList()));
        }
        if (headers.get("Bcc") != null) {
            email.setBcc(Arrays.stream(headers.get("Bcc").split(",")).map(String::trim).collect(Collectors.toList()));
        }
        if (m.getPayload().getBody().getData() != null) {
            email.setBody(new String(Base64.getDecoder().decode(m.getPayload().getBody().getData())));
        } else if (m.getPayload().getParts() != null) {
            Optional<MessagePart> part = m.getPayload().getParts().stream().filter(mp -> "text/plain".equals(mp.getMimeType())).findFirst();
            if (part.isEmpty()) {
                throw new RuntimeException("Expected at least one text/plain message part in the message, but couldn't find any");
            }
            email.setBody(new String(part.get().getBody().decodeData()));
        }
        email.setBody(email.body().trim());
        return email;
    }
}

