/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.mail.validation;

import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.ListMessagesResponse;
import com.google.api.services.gmail.model.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.validation.Validation;
import software.tnb.google.mail.validation.model.GoogleEmail;

public class GoogleMailValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleMailValidation.class);
    private final Gmail client;

    public GoogleMailValidation(Gmail client) {
        this.client = client;
    }

    public List<GoogleEmail> getEmails(String query) {
        ArrayList<GoogleEmail> emails = new ArrayList<GoogleEmail>();
        try {
            ArrayList messages = new ArrayList();
            ListMessagesResponse response = null;
            do {
                if ((response = (ListMessagesResponse)this.client.users().messages().list("me").setQ(query).setPageToken(response == null ? null : response.getNextPageToken()).execute()).getMessages() == null) continue;
                messages.addAll(response.getMessages());
            } while (response.getNextPageToken() != null);
            for (Message message : messages) {
                LOG.trace("Fetching email with id {}", (Object)message.getId());
                emails.add(GoogleEmail.fromPayload((Message)this.client.users().messages().get("me", message.getId()).execute()));
            }
            return emails;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to query emails:", e);
        }
    }
}

