/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.mail.service;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.services.gmail.Gmail;
import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.tnb.google.api.common.service.GoogleAPIService;
import software.tnb.google.mail.validation.GoogleMailValidation;

@AutoService(value={GoogleMail.class})
public class GoogleMail
extends GoogleAPIService<Gmail, GoogleMailValidation> {
    private static final String APPLICATION_NAME = "tnb-system-x-google-mail";

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        LOG.debug("Creating new Google Mail validation");
        this.validation = new GoogleMailValidation(this.client());
    }

    protected Gmail client() {
        if (this.client == null) {
            LOG.debug("Creating new Google Mail client");
            this.client = new Gmail.Builder((HttpTransport)this.httpTransport, JSON_FACTORY, (HttpRequestInitializer)this.createCredentials()).setApplicationName(APPLICATION_NAME).build();
        }
        return (Gmail)this.client;
    }
}

