/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.cloud.functions.service;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auto.service.AutoService;
import com.google.cloud.functions.v1.CloudFunctionsServiceClient;
import com.google.cloud.functions.v1.CloudFunctionsServiceSettings;
import io.fabric8.kubernetes.client.utils.Base64;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.tnb.common.service.Service;
import software.tnb.common.service.ServiceFactory;
import software.tnb.google.cloud.functions.account.GoogleFunctionsAccount;
import software.tnb.google.cloud.functions.validation.GoogleFunctionsValidation;
import software.tnb.google.storage.service.GoogleStorage;

@AutoService(value={GoogleFunctions.class})
public class GoogleFunctions
extends Service<GoogleFunctionsAccount, CloudFunctionsServiceClient, GoogleFunctionsValidation> {
    private final GoogleStorage storage = (GoogleStorage)ServiceFactory.create(GoogleStorage.class);

    protected CloudFunctionsServiceClient client() {
        if (this.client == null) {
            try {
                String decodedJson = new String(Base64.decode((String)((GoogleFunctionsAccount)this.account()).serviceAccountKey()));
                return CloudFunctionsServiceClient.create((CloudFunctionsServiceSettings)((CloudFunctionsServiceSettings.Builder)CloudFunctionsServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)ServiceAccountCredentials.fromStream((InputStream)IOUtils.toInputStream((String)decodedJson, (String)"UTF-8"))))).build());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create new client", e);
            }
        }
        return (CloudFunctionsServiceClient)this.client;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.storage.afterAll(extensionContext);
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.storage.beforeAll(extensionContext);
        this.validation = new GoogleFunctionsValidation((GoogleFunctionsAccount)this.account(), this.client(), this.storage);
    }
}

