/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.cloud.bigquery.validation;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryValidation {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryValidation.class);
    private final BigQuery bigQuery;
    private final String projectId;

    public BigQueryValidation(BigQuery bigQuery, String projectId) {
        this.bigQuery = bigQuery;
        this.projectId = projectId;
    }

    public void createTable(String dataSetId, String tableId, Schema schema) {
        LOG.debug("Creating table {}", (Object)tableId);
        TableId id = TableId.of((String)this.projectId, (String)dataSetId, (String)tableId);
        StandardTableDefinition.Builder builder = StandardTableDefinition.newBuilder().setSchema(schema);
        TableInfo tableInfo = TableInfo.of((TableId)id, (TableDefinition)builder.build());
        this.bigQuery.create(tableInfo, new BigQuery.TableOption[0]);
    }

    public void createTable(String dataSetId, String tableId, FieldList fieldList) {
        this.createTable(dataSetId, tableId, Schema.of((Iterable)fieldList));
    }

    public void createTable(String dataSetId, String tableId, Map<String, StandardSQLTypeName> schema) {
        this.createTable(dataSetId, tableId, FieldList.of((Iterable)schema.entrySet().stream().map(entry -> Field.of((String)((String)entry.getKey()), (StandardSQLTypeName)((StandardSQLTypeName)entry.getValue()), (Field[])new Field[0])).collect(Collectors.toList())));
    }

    public void deleteTable(String datasetName, String tableName) {
        LOG.debug("Deleting table {}", (Object)tableName);
        this.bigQuery.delete(TableId.of((String)this.projectId, (String)datasetName, (String)tableName));
    }

    public void createDataset(String datasetName) {
        LOG.debug("Creating dataset {}", (Object)datasetName);
        this.bigQuery.create(DatasetInfo.newBuilder((String)datasetName).build(), new BigQuery.DatasetOption[0]);
    }

    public void deleteDataset(String datasetName) {
        LOG.debug("Deleting dataset {}", (Object)datasetName);
        this.bigQuery.delete(DatasetId.of((String)this.projectId, (String)datasetName), new BigQuery.DatasetDeleteOption[]{BigQuery.DatasetDeleteOption.deleteContents()});
    }

    public List<FieldValueList> tableContent(String datasetName, String tableName) {
        return StreamSupport.stream(this.query("SELECT * FROM `" + this.projectId + "." + datasetName + "." + tableName + "`").iterateAll().spliterator(), false).collect(Collectors.toList());
    }

    private TableResult query(String query) {
        LOG.debug("Query: {}", (Object)query);
        QueryJobConfiguration queryJobConfiguration = QueryJobConfiguration.of((String)query);
        try {
            return this.bigQuery.query(queryJobConfiguration, new BigQuery.JobOption[0]);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to query BigQuery table", e);
        }
    }
}

