/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.cloud.bigquery.service;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auto.service.AutoService;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.service.Service;
import software.tnb.google.cloud.bigquery.validation.BigQueryValidation;
import software.tnb.google.cloud.common.account.GoogleCloudAccount;

@AutoService(value={GoogleBigQuery.class})
public class GoogleBigQuery
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleBigQuery.class);
    private GoogleCloudAccount account;
    private BigQueryValidation validation;
    private BigQuery client;

    public GoogleCloudAccount account() {
        if (this.account == null) {
            this.account = (GoogleCloudAccount)AccountFactory.create(GoogleCloudAccount.class);
        }
        return this.account;
    }

    protected BigQuery client() throws IOException {
        if (this.client == null) {
            LOG.debug("Creating new Google BigQuery client");
            try {
                this.client = (BigQuery)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials(this.credentialsProvider().getCredentials())).build().getService();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create new Google Storage client", e);
            }
        }
        return this.client;
    }

    private CredentialsProvider credentialsProvider() throws IOException {
        ByteArrayInputStream serviceAccountKey = new ByteArrayInputStream(Base64.getDecoder().decode(this.account().serviceAccountKey()));
        return FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)serviceAccountKey));
    }

    public BigQueryValidation validation() {
        return this.validation;
    }

    public void afterAll(ExtensionContext extensionContext) {
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        LOG.debug("Creating Google BigQuery validation");
        this.validation = new BigQueryValidation(this.client(), this.account().projectId());
    }
}

