/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.cloud.bigquery.validation;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryValidation {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryValidation.class);
    private BigQuery bigQuery;
    private String projectId;

    public BigQueryValidation(BigQuery bigQuery, String projectId) {
        this.bigQuery = bigQuery;
        this.projectId = projectId;
    }

    public void createTableWithSampleSchema(String dataSetId, String tableId) {
        this.createTable(dataSetId, tableId, this.createSampleSchema());
    }

    public void createTable(String dataSetId, String tableId, Schema schema) {
        TableId id = TableId.of((String)this.projectId, (String)dataSetId, (String)tableId);
        StandardTableDefinition.Builder builder = StandardTableDefinition.newBuilder().setSchema(schema);
        TableInfo tableInfo = TableInfo.of((TableId)id, (TableDefinition)builder.build());
        this.bigQuery.create(tableInfo, new BigQuery.TableOption[0]);
    }

    public void deleteTable(String datasetName, String tableName) {
        LOG.debug("Deleting BQ table " + tableName);
        this.bigQuery.delete(TableId.of((String)this.projectId, (String)datasetName, (String)tableName));
    }

    public void createDataset(String datasetName) {
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)datasetName).build();
        Dataset newDataset = this.bigQuery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        String newDatasetName = newDataset.getDatasetId().getDataset();
    }

    public void deleteDataset(String datasetName) {
        DatasetId datasetId = DatasetId.of((String)this.projectId, (String)datasetName);
        this.bigQuery.delete(datasetId, new BigQuery.DatasetDeleteOption[]{BigQuery.DatasetDeleteOption.deleteContents()});
    }

    public long tableRowsCount(String datasetName, String tableName) {
        String query = "SELECT * FROM `" + this.projectId + "." + datasetName + "." + tableName + "`";
        try {
            return this.bigQuery.query(QueryJobConfiguration.of((String)query), new BigQuery.JobOption[0]).getTotalRows();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to query the BQ table", e);
        }
    }

    public boolean tableContainsRow(String datasetName, String tableName, Map<String, String> row) {
        String query = "SELECT * FROM `" + this.projectId + "." + datasetName + "." + tableName + "` WHERE " + row.entrySet().stream().map(e -> (String)e.getKey() + " = '" + (String)e.getValue() + "'").collect(Collectors.joining(" AND "));
        LOG.debug("Query: {}", (Object)query);
        QueryJobConfiguration queryJobConfiguration = QueryJobConfiguration.of((String)query);
        try {
            return this.bigQuery.query(queryJobConfiguration, new BigQuery.JobOption[0]).getTotalRows() == 1L;
        }
        catch (InterruptedException e2) {
            throw new RuntimeException("Unable to query the BQ table", e2);
        }
    }

    public Schema createSchema(Map<String, StandardSQLTypeName> schema) {
        FieldList fields = FieldList.of((Iterable)schema.entrySet().stream().map(entry -> Field.of((String)((String)entry.getKey()), (StandardSQLTypeName)((StandardSQLTypeName)entry.getValue()), (Field[])new Field[0])).collect(Collectors.toList()));
        return Schema.of((Iterable)fields);
    }

    public Schema createSampleSchema() {
        HashMap<String, StandardSQLTypeName> schema = new HashMap<String, StandardSQLTypeName>();
        schema.put("id", StandardSQLTypeName.STRING);
        schema.put("field", StandardSQLTypeName.STRING);
        return this.createSchema(schema);
    }
}

