/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.ftp.sftp.service;

import java.util.Map;
import net.schmizz.sshj.sftp.SFTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.ftp.common.FileTransferService;
import software.tnb.ftp.sftp.account.SFTPAccount;
import software.tnb.ftp.sftp.validation.SFTPValidation;

public abstract class SFTP
implements FileTransferService,
WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(SFTP.class);
    private SFTPAccount account;
    private SFTPValidation validation;

    public abstract SFTPClient client();

    @Override
    public int port() {
        return 22;
    }

    @Override
    public SFTPAccount account() {
        if (this.account == null) {
            this.account = (SFTPAccount)AccountFactory.create(SFTPAccount.class);
        }
        return this.account;
    }

    @Override
    public SFTPValidation validation() {
        if (this.validation == null) {
            LOG.debug("Creating new Ftp validation");
            this.validation = new SFTPValidation(this.account(), this.client());
        }
        return this.validation;
    }

    public Map<String, String> containerEnvironment() {
        return Map.of("SFTP_USERS", String.format("%s:%s:::%s", this.account().username(), this.account().password(), this.account().baseDir()));
    }

    public String defaultImage() {
        return "quay.io/fuse_qe/sftp:alpine";
    }
}

