/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.ftp.ftp.service;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.ftp.common.FileTransferService;
import software.tnb.ftp.ftp.account.FTPAccount;
import software.tnb.ftp.ftp.service.CustomFTPClient;
import software.tnb.ftp.ftp.validation.FTPValidation;

public abstract class FTP
implements FileTransferService,
WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(FTP.class);
    private FTPAccount account;
    private FTPValidation validation;

    protected abstract CustomFTPClient client();

    @Override
    public FTPAccount account() {
        if (this.account == null) {
            this.account = (FTPAccount)AccountFactory.create(FTPAccount.class);
        }
        return this.account;
    }

    @Override
    public FTPValidation validation() {
        if (this.validation == null) {
            LOG.debug("Creating new Ftp validation");
            this.validation = new FTPValidation(this.client());
        }
        return this.validation;
    }

    public Map<String, String> containerEnvironment() {
        return Map.of("FTP_USERNAME", this.account().username(), "FTP_PASSWORD", this.account().password(), "USERS", String.format("%s|%s", this.account.username(), this.account.password()));
    }

    protected String basePath() {
        return "/tmp/" + this.account().username();
    }

    public String defaultImage() {
        return "quay.io/fuse_qe/apache-ftp:latest";
    }
}

