/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.ftp.sftp.resource.openshift;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShiftWaiters;
import cz.xtf.core.openshift.helpers.ResourceFunctions;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.SecurityContextFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.PortForward;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithExternalHostname;
import software.tnb.common.deployment.WithInClusterHostname;
import software.tnb.common.deployment.WithName;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.IOUtils;
import software.tnb.common.utils.WaitUtils;
import software.tnb.ftp.sftp.service.SFTP;

@AutoService(value={SFTP.class})
public class OpenshiftSFTP
extends SFTP
implements OpenshiftDeployable,
WithName,
WithInClusterHostname,
WithExternalHostname {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftSFTP.class);
    private static final String SCC_NAME = "tnb-sftp";
    public static final int LOCAL_PORT = 3322;
    private SFTPClient client;
    private PortForward portForward;
    private String serviceAccountName;

    public void create() {
        LinkedList<ContainerPort> ports = new LinkedList<ContainerPort>();
        ports.add(((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("sftp")).withContainerPort(Integer.valueOf(this.port()))).withProtocol("TCP")).build());
        this.serviceAccountName = this.name() + "-sa";
        OpenshiftClient.get().serviceAccounts().createOrReplace((Object[])new ServiceAccount[]{((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName(this.serviceAccountName)).endMetadata()).build()});
        OpenshiftClient.get().addUsersToSecurityContext(OpenshiftClient.get().createSecurityContext(SCC_NAME, "anyuid", new String[]{"SYS_CHROOT"}), new String[]{OpenshiftClient.get().getServiceAccountRef(this.serviceAccountName)});
        OpenshiftClient.get().apps().deployments().createOrReplace((Object[])new Deployment[]{((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.SecurityContextNested)((SecurityContextFluent.CapabilitiesNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).addToAnnotations("openshift.io/scc", SCC_NAME)).endMetadata()).editOrNewSpec().editOrNewSelector().addToMatchLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endSelector()).withReplicas(Integer.valueOf(1))).editOrNewTemplate().editOrNewMetadata().addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().withServiceAccount(this.serviceAccountName)).addNewContainer().withName(this.name())).withImage(this.image())).addAllToPorts(ports)).withImagePullPolicy("IfNotPresent")).withEnv(new EnvVar[]{new EnvVar("SFTP_USERS", this.containerEnvironment().get("SFTP_USERS"), null)})).editOrNewSecurityContext().editOrNewCapabilities().addNewAdd("SYS_CHROOT")).endCapabilities()).endSecurityContext()).endContainer()).endSpec()).endTemplate()).endSpec()).build()});
        ServiceSpecBuilder serviceSpecBuilder = (ServiceSpecBuilder)new ServiceSpecBuilder().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name());
        serviceSpecBuilder.addToPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("sftp")).withPort(Integer.valueOf(this.port()))).withTargetPort(new IntOrString(Integer.valueOf(this.port())))).build()});
        OpenshiftClient.get().services().createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpecLike(serviceSpecBuilder.build()).endSpec()).build()});
    }

    public void undeploy() {
        LOG.info("Undeploying OpenShift sftp");
        SecurityContextConstraints scc = (SecurityContextConstraints)((Resource)OpenshiftClient.get().securityContextConstraints().withName(SCC_NAME)).edit(new Visitor[0]);
        scc.getUsers().remove("system:serviceaccount:" + OpenshiftConfiguration.openshiftNamespace() + ":" + this.serviceAccountName);
        ((Resource)OpenshiftClient.get().securityContextConstraints().withName(SCC_NAME)).patch((Object)scc);
        ((ServiceResource)OpenshiftClient.get().services().withName(this.name())).delete();
        ((RollableScalableResource)OpenshiftClient.get().apps().deployments().withName(this.name())).delete();
        OpenShiftWaiters.get((OpenShift)OpenshiftClient.get(), () -> false).areNoPodsPresent(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name()).timeout(120000L).waitFor();
    }

    public void openResources() {
        this.portForward = (PortForward)((ServiceResource)OpenshiftClient.get().services().withName(this.name())).portForward(this.port(), 3322);
        WaitUtils.sleep((long)1000L);
        this.makeClient();
    }

    public void closeResources() {
        IOUtils.closeQuietly((Closeable)this.client);
        IOUtils.closeQuietly((Closeable)this.portForward);
    }

    public boolean isReady() {
        return (Boolean)ResourceFunctions.areExactlyNPodsReady((int)1).apply(OpenshiftClient.get().getLabeledPods(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())) != false && OpenshiftClient.get().getLogs(OpenshiftClient.get().getAnyPod(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).contains("Server listening on");
    }

    public boolean isDeployed() {
        return OpenshiftClient.get().getLabeledPods(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name()).size() != 0;
    }

    public String name() {
        return "sftp";
    }

    @Override
    public SFTPClient client() {
        return this.client;
    }

    private void makeClient() {
        try {
            LOG.debug("Creating new SFTPClient instance");
            SSHClient sshClient = new SSHClient();
            sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            sshClient.connect(this.externalHostname(), 3322);
            sshClient.authPassword(this.account().username(), this.account().password());
            this.client = sshClient.newSFTPClient();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String host() {
        return this.inClusterHostname();
    }

    public String externalHostname() {
        return "localhost";
    }
}

