/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.ftp.sftp.resource.local;

import com.github.dockerjava.api.model.ContainerNetwork;
import com.google.auto.service.AutoService;
import java.io.Closeable;
import java.io.IOException;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.common.utils.IOUtils;
import software.tnb.ftp.sftp.resource.local.SftpContainer;
import software.tnb.ftp.sftp.service.SFTP;

@AutoService(value={SFTP.class})
public class LocalSFTP
extends SFTP
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalSFTP.class);
    private SftpContainer container;
    private SFTPClient client;

    public void deploy() {
        LOG.info("Starting sftp container");
        this.container = new SftpContainer(this.image(), this.containerEnvironment());
        this.container.start();
    }

    public void undeploy() {
        this.container.stop();
    }

    public void openResources() {
        try {
            LOG.debug("Creating new SFTPClient instance");
            SSHClient sshClient = new SSHClient();
            sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            sshClient.connect(this.host(), this.port());
            sshClient.authPassword(this.account().username(), this.account().password());
            this.client = sshClient.newSFTPClient();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void closeResources() {
        IOUtils.closeQuietly((Closeable)this.client);
    }

    @Override
    public SFTPClient client() {
        return this.client;
    }

    @Override
    public String host() {
        return ((ContainerNetwork)this.container.getContainerInfo().getNetworkSettings().getNetworks().get("bridge")).getIpAddress();
    }
}

