/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.ftp.ftp.resource.local;

import com.github.dockerjava.api.model.ContainerNetwork;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.images.builder.Transferable;
import software.tnb.common.deployment.Deployable;
import software.tnb.ftp.ftp.resource.local.FTPContainer;
import software.tnb.ftp.ftp.service.CustomFTPClient;
import software.tnb.ftp.ftp.service.FTP;

@AutoService(value={FTP.class})
public class LocalFTP
extends FTP
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFTP.class);
    private FTPContainer container;
    private final CustomFTPClient client = new TestContainerFTPOutOfBandClient();

    public void deploy() {
        LOG.info("Starting Ftp container");
        this.container = new FTPContainer(this.image(), this.port(), this.containerEnvironment());
        this.container.start();
        LOG.info("Ftp container started");
    }

    public void undeploy() {
        if (this.container != null) {
            LOG.info("Stopping Ftp container");
            this.container.stop();
        }
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    @Override
    protected CustomFTPClient client() {
        return this.client;
    }

    @Override
    public int port() {
        return 2121;
    }

    @Override
    public String host() {
        return ((ContainerNetwork)this.container.getContainerInfo().getNetworkSettings().getNetworks().get("bridge")).getIpAddress();
    }

    public class TestContainerFTPOutOfBandClient
    implements CustomFTPClient {
        @Override
        public void storeFile(String fileName, InputStream fileContent) throws IOException {
            LocalFTP.this.container.copyFileToContainer(Transferable.of((byte[])fileContent.readAllBytes(), (int)16895), LocalFTP.this.basePath() + "/" + fileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void retrieveFile(String fileName, OutputStream local) throws IOException {
            Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                LocalFTP.this.container.copyFileFromContainer(LocalFTP.this.basePath() + "/" + fileName, tempFile.toString());
                IOUtils.copy((InputStream)Files.newInputStream(tempFile, new OpenOption[0]), (OutputStream)local);
            }
            finally {
                tempFile.toFile().delete();
            }
        }

        @Override
        public void makeDirectory(String dirName) throws IOException {
            try {
                LocalFTP.this.container.execInContainer(new String[]{String.format("mkdir -m a=rwx '%s/%s'", LocalFTP.this.basePath(), dirName)});
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

