/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.ftp.sftp.validation;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.schmizz.sshj.sftp.SFTPClient;
import org.junit.jupiter.api.Assertions;
import software.tnb.common.utils.IOUtils;
import software.tnb.ftp.common.FileTransferValidation;
import software.tnb.ftp.sftp.account.SFTPAccount;

public class SFTPValidation
implements FileTransferValidation {
    private final SFTPClient client;
    private final SFTPAccount account;

    public SFTPValidation(SFTPAccount account, SFTPClient client) {
        this.client = client;
        this.account = account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFile(String fileName, String fileContent) {
        Path tempFile = this.createTempFile();
        try {
            IOUtils.writeFile((Path)tempFile, (String)fileContent);
            this.client.put(tempFile.toString(), this.getRemoteFileName(fileName));
        }
        catch (IOException e) {
            Assertions.fail((String)"Validation could not create file in SFTP", (Throwable)e);
        }
        finally {
            tempFile.toFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String downloadFile(String fileName) {
        Path tempFile = this.createTempFile();
        try {
            this.client.get(this.getRemoteFileName(fileName), tempFile.toString());
            String string = IOUtils.readFile((Path)tempFile);
            return string;
        }
        catch (IOException e) {
            String string = (String)Assertions.fail((String)"Validation could not download file from SFTP", (Throwable)e);
            return string;
        }
        finally {
            tempFile.toFile().delete();
        }
    }

    @Override
    public void createDirectory(String dirName) {
        try {
            this.client.mkdir(this.account.baseDir() + "/" + dirName);
        }
        catch (IOException e) {
            Assertions.fail((String)"Validation could not create directory in SFTP", (Throwable)e);
        }
    }

    private String getRemoteFileName(String fileName) {
        return this.account.baseDir() + "/" + fileName;
    }

    private Path createTempFile() {
        Path tempFile = null;
        try {
            tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
        }
        catch (IOException e) {
            Assertions.fail((String)"Validation could not create temp file", (Throwable)e);
        }
        return tempFile;
    }
}

