/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.ftp.ftp.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import software.tnb.ftp.common.FileTransferValidation;
import software.tnb.ftp.ftp.service.CustomFTPClient;

public class FTPValidation
implements FileTransferValidation {
    private final CustomFTPClient client;

    public FTPValidation(CustomFTPClient client) {
        this.client = client;
    }

    @Override
    public void createFile(String fileName, String fileContent) {
        try {
            this.client.storeFile(fileName, new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            Assertions.fail((String)"Validation could not store file in FTP", (Throwable)e);
        }
    }

    @Override
    public String downloadFile(String fileName) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.client.retrieveFile(fileName, baos);
            return baos.toString();
        }
        catch (IOException e) {
            return (String)Assertions.fail((String)"Validation could not download file from FTP", (Throwable)e);
        }
    }

    @Override
    public void createDirectory(String dirName) {
        try {
            this.client.makeDirectory(dirName);
        }
        catch (IOException e) {
            Assertions.fail((String)"Validation could not create directory in FTP", (Throwable)e);
        }
    }
}

