/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.ftp.ftp.resource.openshift;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShiftWaiters;
import cz.xtf.core.openshift.helpers.ResourceFunctions;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.dsl.CopyOrReadable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithInClusterHostname;
import software.tnb.common.deployment.WithName;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.ftp.ftp.service.CustomFTPClient;
import software.tnb.ftp.ftp.service.FTP;

@AutoService(value={FTP.class})
public class OpenshiftFTP
extends FTP
implements OpenshiftDeployable,
WithName,
WithInClusterHostname {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftFTP.class);
    private final CustomFTPClient client = new OpenShiftFTPClient();
    public static final int FTP_COMMAND_PORT = 2121;
    public static final int FTP_DATA_PORT_START = 2122;
    public static final int FTP_DATA_PORT_END = 2130;

    public void create() {
        LinkedList<ContainerPort> ports = new LinkedList<ContainerPort>();
        ports.add(((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("ftp-cmd")).withContainerPort(Integer.valueOf(this.port()))).withProtocol("TCP")).build());
        for (int dataPort = 2122; dataPort <= 2130; ++dataPort) {
            ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("ftp-data-" + dataPort)).withContainerPort(Integer.valueOf(dataPort))).withProtocol("TCP")).build();
            ports.add(containerPort);
        }
        OpenshiftClient.get().apps().deployments().createOrReplace((Object[])new Deployment[]{((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().editOrNewSelector().addToMatchLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endSelector()).withReplicas(Integer.valueOf(1))).editOrNewTemplate().editOrNewMetadata().addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addNewContainer().withName(this.name())).withImage(this.image())).addAllToPorts(ports)).withEnv(new EnvVar[]{new EnvVar("USERS", this.containerEnvironment().get("USERS"), null)})).endContainer()).endSpec()).endTemplate()).endSpec()).build()});
        ServiceSpecBuilder serviceSpecBuilder = (ServiceSpecBuilder)new ServiceSpecBuilder().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name());
        serviceSpecBuilder.addToPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("ftp-cmd")).withPort(Integer.valueOf(this.port()))).withTargetPort(new IntOrString(Integer.valueOf(this.port())))).build()});
        for (int dataPort = 2122; dataPort <= 2130; ++dataPort) {
            serviceSpecBuilder.addToPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("ftp-data-" + dataPort)).withPort(Integer.valueOf(dataPort))).withTargetPort(new IntOrString(Integer.valueOf(dataPort)))).build()});
        }
        OpenshiftClient.get().services().createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpecLike(serviceSpecBuilder.build()).endSpec()).build()});
    }

    public void undeploy() {
        LOG.info("Undeploying OpenShift ftp");
        ((ServiceResource)OpenshiftClient.get().services().withName(this.name())).delete();
        ((RollableScalableResource)OpenshiftClient.get().apps().deployments().withName(this.name())).delete();
        OpenShiftWaiters.get((OpenShift)OpenshiftClient.get(), () -> false).areNoPodsPresent(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name()).timeout(120000L).waitFor();
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    public boolean isReady() {
        return (Boolean)ResourceFunctions.areExactlyNPodsReady((int)1).apply(OpenshiftClient.get().getLabeledPods(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())) != false && OpenshiftClient.get().getLogs(OpenshiftClient.get().getAnyPod(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).contains("FtpServer started");
    }

    public boolean isDeployed() {
        Deployment deployment = (Deployment)((RollableScalableResource)OpenshiftClient.get().apps().deployments().withName(this.name())).get();
        return deployment != null && !deployment.isMarkedForDeletion() && this.isReady();
    }

    public String name() {
        return "ftp";
    }

    @Override
    protected CustomFTPClient client() {
        return this.client;
    }

    @Override
    public int port() {
        return 2121;
    }

    @Override
    public String host() {
        return this.inClusterHostname();
    }

    public class OpenShiftFTPClient
    implements CustomFTPClient {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void storeFile(String fileName, InputStream fileContent) throws IOException {
            Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                Files.copy(fileContent, tempFile, StandardCopyOption.REPLACE_EXISTING);
                ((CopyOrReadable)this.getPodResource().file("/tmp/" + OpenshiftFTP.this.account().username() + "/" + fileName)).upload(tempFile);
            }
            finally {
                tempFile.toFile().delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void retrieveFile(String fileName, OutputStream local) throws IOException {
            Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                ((CopyOrReadable)this.getPodResource().file("/tmp/" + OpenshiftFTP.this.account().username() + "/" + fileName)).copy(tempFile);
                IOUtils.copy((InputStream)Files.newInputStream(tempFile, new OpenOption[0]), (OutputStream)local);
            }
            finally {
                tempFile.toFile().delete();
            }
        }

        @Override
        public void makeDirectory(String dirName) {
            ((TtyExecErrorable)this.getPodResource().writingOutput((Object)new ByteArrayOutputStream())).exec((Object[])new String[]{"mkdir", "-p", "-m", "a=rwx", String.format("%s/%s", OpenshiftFTP.this.basePath(), dirName)});
        }

        private PodResource<Pod> getPodResource() {
            Pod ftpPod = OpenshiftClient.get().getAnyPod(OpenshiftConfiguration.openshiftDeploymentLabel(), OpenshiftFTP.this.name());
            return (PodResource)OpenshiftClient.get().pods().withName(ftpPod.getMetadata().getName());
        }
    }
}

