/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.filesystem.resource.openshift;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShiftWaiters;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.CopyOrReadable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.filesystem.service.FileSystem;

@AutoService(value={FileSystem.class})
public class OpenShiftFileSystem
extends FileSystem {
    private static final String NAMESPACE = OpenshiftClient.get().getNamespace();
    private String podLabelValue;

    @Override
    public void setAppName(String app) {
        this.podLabelValue = app;
    }

    @Override
    public String getFileContent(Path path) {
        String string;
        block8: {
            String podLabelKey = "deploymentconfig";
            this.podIsReady("deploymentconfig", this.podLabelValue);
            String podName = this.getPodName("deploymentconfig", this.podLabelValue);
            Pod pod = OpenshiftClient.get().getPod(podName);
            String integrationContainer = OpenshiftClient.get().getIntegrationContainer(pod);
            InputStream is = (InputStream)((CopyOrReadable)((ContainerResource)((PodResource)((NonNamespaceOperation)OpenshiftClient.get().pods().inNamespace(NAMESPACE)).withName(podName)).inContainer((Object)integrationContainer)).file(path.toString())).read();
            try {
                string = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return string;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
    }

    private String getPodName(String key, String value) {
        return ((Pod)OpenshiftClient.get().getLabeledPods(key, value).get(0)).getMetadata().getName();
    }

    private void podIsReady(String key, String value) {
        try {
            OpenShiftWaiters.get((OpenShift)OpenshiftClient.get(), () -> false).areExactlyNPodsReady(1, key, value).interval(TimeUnit.SECONDS, 10L).timeout(TimeUnit.MINUTES, 10L).waitFor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

