/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.common.validation;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Consumer;
import software.tnb.common.validation.Validation;
import software.tnb.db.common.account.SQLAccount;

public class SQLValidation
implements Validation {
    private final String jdbcConnectionUrl;
    private final SQLAccount account;

    public SQLValidation(String jdbcConnectionUrl, SQLAccount account) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
        this.account = account;
    }

    public boolean execute(String sql) {
        boolean bl;
        block8: {
            Connection conn = DriverManager.getConnection(this.jdbcConnectionUrl, this.account.username(), this.account.password());
            try {
                bl = conn.createStatement().execute(sql);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Unable to execute query", e);
                }
            }
            conn.close();
        }
        return bl;
    }

    public ResultSet executeQuery(String sql) {
        ResultSet resultSet;
        block8: {
            Connection conn = DriverManager.getConnection(this.jdbcConnectionUrl, this.account.username(), this.account.password());
            try {
                resultSet = conn.createStatement().executeQuery(sql);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Unable to execute query", e);
                }
            }
            conn.close();
        }
        return resultSet;
    }

    public void checkQueryResult(String sql, Consumer<ResultSet> check) {
        try (Connection conn = DriverManager.getConnection(this.jdbcConnectionUrl, this.account.username(), this.account.password());){
            check.accept(conn.createStatement().executeQuery(sql));
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to execute query", e);
        }
    }
}

