/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.common.service;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.client.NoClient;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.common.deployment.WithExternalHostname;
import software.tnb.common.deployment.WithName;
import software.tnb.common.service.Service;
import software.tnb.db.common.account.SQLAccount;
import software.tnb.db.common.validation.SQLValidation;

public abstract class SQL
extends Service<SQLAccount, NoClient, SQLValidation>
implements WithName,
WithExternalHostname,
WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(SQL.class);

    protected abstract Class<? extends SQLAccount> accountClass();

    public SQLAccount account() {
        if (this.account == null) {
            this.account = AccountFactory.create(this.accountClass());
        }
        return (SQLAccount)this.account;
    }

    public abstract String jdbcConnectionUrl();

    public abstract String hostname();

    public abstract int port();

    public int localPort() {
        return this.port();
    }

    public SQLValidation validation() {
        if (this.validation == null) {
            LOG.debug("Creating new SQL validation");
            this.validation = new SQLValidation(this.localConnectionUrl(), this.account());
        }
        return (SQLValidation)this.validation;
    }

    protected String localConnectionUrl() {
        return OpenshiftConfiguration.isOpenshift() ? this.jdbcConnectionUrl().replace("://" + this.hostname(), "://" + this.externalHostname()).replace(":" + this.port(), ":" + this.localPort()) : this.jdbcConnectionUrl();
    }

    public abstract Map<String, String> containerEnvironment();

    public String externalHostname() {
        return "localhost";
    }
}

