/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.common.local;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import software.tnb.common.deployment.Deployable;
import software.tnb.db.common.local.DBContainer;
import software.tnb.db.common.service.SQL;

public class LocalDB
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDB.class);
    private final SQL sqlService;
    private final DBContainer container;

    public LocalDB(SQL sqlService, int port, WaitStrategy waitStrategy) {
        this.sqlService = sqlService;
        this.container = new DBContainer(sqlService, port, waitStrategy);
    }

    public void deploy() {
        LOG.info("Starting " + this.sqlService.name() + " container");
        this.container.start();
        LOG.info(this.sqlService.name() + " container started");
    }

    public void undeploy() {
        this.container.stop();
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    public int getPort() {
        return this.container.getPort();
    }

    public String getHost() {
        return this.container.getHost();
    }
}

