/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.cryostat.resource.openshift;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.helpers.ResourceParsers;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.ReusableOpenshiftDeployable;
import software.tnb.common.deployment.WithOperator;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.HTTPUtils;
import software.tnb.common.utils.WaitUtils;
import software.tnb.cryostat.client.CryostatClient;
import software.tnb.cryostat.client.openshift.OpenshiftCryostatClient;
import software.tnb.cryostat.service.Cryostat;

@AutoService(value={Cryostat.class})
public class OpenshiftCryostat
extends Cryostat
implements ReusableOpenshiftDeployable,
WithOperator {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftCryostat.class);
    private static final String DEFAULT_CHANNEL = "stable";
    private static final String OPERATOR_NAME = "cryostat-operator";
    private static final String DEFAULT_SOURCE = "redhat-operators";
    private static final String SUBSCRIPTION_NAME = "tnb-cryostat";
    private static final String SUBSCRIPTION_NAMESPACE = "openshift-marketplace";
    private static final String APP_NAME = "cryostat-" + OpenshiftClient.get().getNamespace();
    private static final CustomResourceDefinitionContext CRYOSTAT_CTX = new CustomResourceDefinitionContext.Builder().withName("Cryostat").withGroup("operator.cryostat.io").withVersion("v1beta1").withPlural("cryostats").withScope("Namespaced").build();

    public void undeploy() {
        try {
            OpenshiftClient.get().customResource(CRYOSTAT_CTX).delete(OpenshiftClient.get().getNamespace(), APP_NAME, true);
            WaitUtils.waitFor(() -> OpenshiftClient.get().getLabeledPods(Map.of("kind", "cryostat", "app", APP_NAME)).isEmpty(), (String)"Waiting until Cryostat pods are deleted");
            OpenshiftClient.get().deleteSubscription(SUBSCRIPTION_NAME);
        }
        catch (IOException e) {
            LOG.error("Error on Cryostat deletetion", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void openResources() {
        this.validation().init();
    }

    public void closeResources() {
    }

    public void create() {
        LOG.debug("Creating Cryostat instance");
        OpenshiftClient.get().createSubscription(this.operatorChannel(), OPERATOR_NAME, this.operatorCatalog(), SUBSCRIPTION_NAME, SUBSCRIPTION_NAMESPACE);
        OpenshiftClient.get().waitForInstallPlanToComplete(SUBSCRIPTION_NAME);
        try {
            OpenshiftClient.get().customResource(CRYOSTAT_CTX).createOrReplace(this.getCryostatDefinition());
        }
        catch (IOException e) {
            LOG.error("Error on Cryostat creation", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isReady() {
        List labeledPods = OpenshiftClient.get().getLabeledPods(Map.of("kind", "cryostat", "app", APP_NAME));
        try {
            return labeledPods.size() > 0 && labeledPods.stream().allMatch(Readiness::isPodReady) && HTTPUtils.trustAllSslClient().newCall(new Request.Builder().get().url(String.format("https://%s/health", OpenshiftClient.get().getRoute(APP_NAME).getSpec().getHost())).build()).execute().isSuccessful();
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isDeployed() {
        List pods = ((PodList)((FilterWatchListDeletable)OpenshiftClient.get().pods().withLabel("control-plane", "controller-manager")).list()).getItems().stream().filter(p -> p.getMetadata().getName().contains("cryostat")).collect(Collectors.toList());
        return pods.size() == 1 && ResourceParsers.isPodReady((Pod)((Pod)pods.get(0))) && ((List)OpenshiftClient.get().customResource(CRYOSTAT_CTX).list().get("items")).size() == 1;
    }

    @Override
    public String connectionUrl() {
        return String.format("https://%s", OpenshiftClient.get().getRoute(APP_NAME).getSpec().getHost());
    }

    @Override
    public CryostatClient client() {
        return new OpenshiftCryostatClient(this.connectionUrl());
    }

    @Override
    public int getPortMapping(int port) {
        return 8181;
    }

    private Map<String, Object> getCryostatDefinition() {
        Map<String, String> metadata = Map.of("name", APP_NAME, "namespace", OpenshiftClient.get().getNamespace());
        Map<String, Boolean> spec = Map.of("enableCertManager", false, "minimal", true);
        return Map.of("kind", CRYOSTAT_CTX.getName(), "apiVersion", String.format("%s/%s", CRYOSTAT_CTX.getGroup(), CRYOSTAT_CTX.getVersion()), "metadata", metadata, "spec", spec);
    }

    public void cleanup() {
    }

    public String defaultOperatorCatalog() {
        return DEFAULT_SOURCE;
    }

    public String defaultOperatorChannel() {
        return DEFAULT_CHANNEL;
    }
}

