/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.cryostat.resource.local;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.common.utils.HTTPUtils;
import software.tnb.common.utils.WaitUtils;
import software.tnb.cryostat.client.CryostatClient;
import software.tnb.cryostat.client.local.LocalCryostatClient;
import software.tnb.cryostat.resource.local.CryostatContainer;
import software.tnb.cryostat.service.Cryostat;

@AutoService(value={Cryostat.class})
public class LocalCryostat
extends Cryostat
implements Deployable,
WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCryostat.class);
    private CryostatContainer container;

    public void deploy() {
        LOG.info("Starting Cryostat");
        this.container = new CryostatContainer(this.image(), this.containerEnvironment());
        this.container.start();
        LOG.info("Cryostat container started");
    }

    public void undeploy() {
        if (this.container != null) {
            LOG.info("Stopping Cryostat container");
            this.container.stop();
        }
    }

    public void openResources() {
        HTTPUtils client = HTTPUtils.getInstance((OkHttpClient)HTTPUtils.trustAllSslClient());
        WaitUtils.waitFor(() -> client.get(String.format("%s/health", this.connectionUrl()), false).isSuccessful(), (String)"wait for container ready");
        this.validation().init();
    }

    public void closeResources() {
    }

    @Override
    public String connectionUrl() {
        return String.format("http://localhost:%s", this.getPortMapping(8181));
    }

    @Override
    public CryostatClient client() {
        return new LocalCryostatClient(this.connectionUrl());
    }

    @Override
    public int getPortMapping(int port) {
        return port;
    }

    protected Map<String, String> containerEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("CRYOSTAT_DISABLE_JMX_AUTH", "true");
        env.put("CRYOSTAT_ALLOW_UNTRUSTED_SSL", "true");
        env.put("CRYOSTAT_DISABLE_SSL", "true");
        return env;
    }

    public String defaultImage() {
        return "registry.redhat.io/cryostat-tech-preview/cryostat-rhel8:latest";
    }
}

