/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.cryostat.client.local;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.cryostat.client.BaseCryostatClient;
import software.tnb.cryostat.generated.recording.Recording;
import software.tnb.cryostat.generated.targets.Target;

public class LocalCryostatClient
extends BaseCryostatClient {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCryostatClient.class);
    private final String connectionUrl;
    private final OkHttpClient apiClient;
    private final ObjectMapper mapper = new ObjectMapper();

    public LocalCryostatClient(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        this.apiClient = new OkHttpClient();
    }

    @Override
    public void authenticate(String apiContextUrl) throws IOException {
        Request request = this.getRequestForUrl(apiContextUrl).post(RequestBody.create(null, (byte[])new byte[0])).build();
        try (Response resp = this.apiClient.newCall(request).execute();){
            if (!resp.isSuccessful()) {
                throw new RuntimeException(String.format("unable to connect to Cryostat: %s %s", resp.code(), resp.message()));
            }
        }
    }

    @Override
    public List<Target> targets(String apiContextUrl) throws IOException {
        return this.get(apiContextUrl, "unable to retrieve targets: %s %s", new TypeReference<List>(){}).stream().map(m -> {
            try {
                return (Target)this.mapper.readValue(this.mapper.writeValueAsString(m), Target.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void addTarget(String apiContextUrl, String alias, String appName) throws IOException {
        String ip = this.getIp(appName);
        String port = this.getPort();
        String podName = this.getPodName(appName);
        this.post(apiContextUrl, Map.of("connectUrl", String.format("service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi", ip, port), "alias", alias, "annotations.cryostat.HOST", ip, "annotations.cryostat.PORT", port, "annotations.cryostat.POD_NAME", podName), Map.class);
    }

    @Override
    public List<Recording> recordings(String apiContextUrl) throws IOException {
        return this.get(apiContextUrl, "unable to retrieve recordings: %s %s", new TypeReference<List<Recording>>(){});
    }

    @Override
    public void startRecording(String apiContextUrl, String name, Map<String, String> labels) throws IOException {
        Response result = this.post(apiContextUrl, Map.of("recordingName", name, "events", "template=" + this.getJfrTemplate(), "metadata", "{\"labels\":" + this.mapper.writeValueAsString(labels) + "}"), Reader.class);
        if (result.code() != 201) {
            throw new IOException("Unable to start recording :" + result.code());
        }
    }

    @Override
    public void stopRecording(String apiContextUrl) throws IOException {
        Request req = this.getRequestForUrl(apiContextUrl).patch(RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)"STOP")).build();
        Response resp = this.apiClient.newCall(req).execute();
        if (!resp.isSuccessful()) {
            throw new RuntimeException(String.format("error on stopping recording on %s: %s %s", apiContextUrl, resp.code(), resp.message()));
        }
    }

    @Override
    public void downloadRecording(String apiContextUrl, String destinationPath) throws IOException {
        Request req = this.getRequestForUrl(apiContextUrl).build();
        Response resp = this.apiClient.newCall(req).execute();
        if (!resp.isSuccessful()) {
            throw new RuntimeException(String.format("error on downloading recording at %s: %s %s", apiContextUrl, resp.code(), resp.message()));
        }
        Files.createDirectories(Paths.get(destinationPath, new String[0]).getParent(), new FileAttribute[0]);
        try (FileOutputStream out = new FileOutputStream(destinationPath);){
            IOUtils.copy((InputStream)resp.body().byteStream(), (OutputStream)out);
        }
    }

    @Override
    public void deleteRecording(String apiContextUrl) throws IOException {
        this.delete(apiContextUrl);
    }

    @Override
    public String getIp(String appName) {
        return "localhost";
    }

    @Override
    public String getPort() {
        return "9096";
    }

    @Override
    public String getPodName(String appName) {
        return this.getIp(appName);
    }

    private <T> T get(String apiContextUrl, String msg, TypeReference<T> returnType) throws IOException {
        Request request = this.getRequestForUrl(apiContextUrl).build();
        try (Response resp = this.apiClient.newCall(request).execute();){
            if (!resp.isSuccessful()) {
                throw new RuntimeException(String.format(msg, resp.code(), resp.message()));
            }
            Object object = this.mapper.readValue(resp.body().source().inputStream(), new TypeReference<T>(){});
            return (T)object;
        }
    }

    private Request.Builder getRequestForUrl(String apiContextUrl) {
        return new Request.Builder().url(String.format("%s%s", this.connectionUrl, apiContextUrl));
    }

    private <T> Response post(String apiContextUrl, String contentType, byte[] body, Class<T> returnType) throws IOException {
        Request req = this.getRequestForUrl(apiContextUrl).post(RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])body)).build();
        return this.postRequest(apiContextUrl, returnType, req);
    }

    private <T> Response post(String apiContextUrl, Map<String, String> body, Class<T> returnType) throws IOException {
        Request req = this.getRequestForUrl(apiContextUrl).post(RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (String)body.entrySet().stream().map(e -> {
            try {
                return URLEncoder.encode((String)e.getKey(), StandardCharsets.UTF_8.displayName()) + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8.displayName());
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.joining("&")))).build();
        return this.postRequest(apiContextUrl, returnType, req);
    }

    private <T> Response postRequest(String apiContextUrl, Class<T> returnType, Request req) throws IOException {
        Response resp = this.apiClient.newCall(req).execute();
        if (!resp.isSuccessful()) {
            LOG.error("error sending POST to {}: {}", (Object)apiContextUrl, (Object)(resp.body() != null ? resp.body().string() : "no body"));
            throw new RuntimeException(String.format("error on posting on %s: %s %s", apiContextUrl, resp.code(), resp.message()));
        }
        return resp;
    }

    private void delete(String apiContextUrl) throws IOException {
        Request req = this.getRequestForUrl(apiContextUrl).delete().build();
        Response resp = this.apiClient.newCall(req).execute();
        if (!resp.isSuccessful()) {
            throw new RuntimeException(String.format("error deleting %s: %s %s", apiContextUrl, resp.code(), resp.message()));
        }
    }
}

