/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.cryostat.resource.local;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;

public class CryostatContainer
extends GenericContainer<CryostatContainer> {
    private static final Path CONF_PATH;
    private static final Path PROBES_PATH;
    private static final Path RECORDINGS_PATH;
    private static final Path TEMPLATES_PATH;
    private static final Path CLIENTLIB_PATH;

    public CryostatContainer(String image, Map<String, String> env) {
        super(image);
        this.withEnv(env);
        this.withFileSystemBind(CONF_PATH.toAbsolutePath().toString(), "/opt/cryostat.d/conf.d", BindMode.READ_WRITE);
        this.withFileSystemBind(PROBES_PATH.toAbsolutePath().toString(), "/opt/cryostat.d/probes.d", BindMode.READ_WRITE);
        this.withFileSystemBind(RECORDINGS_PATH.toAbsolutePath().toString(), "/opt/cryostat.d/recordings.d", BindMode.READ_WRITE);
        this.withFileSystemBind(TEMPLATES_PATH.toAbsolutePath().toString(), "/opt/cryostat.d/templates.d", BindMode.READ_WRITE);
        this.withFileSystemBind(CLIENTLIB_PATH.toAbsolutePath().toString(), "/opt/cryostat.d/clientlib.d", BindMode.READ_WRITE);
        this.withNetworkMode("host");
    }

    private static Path createFolder(String name, Stream<String> subFolders) throws IOException {
        Path root = Files.createTempDirectory(name, new FileAttribute[0]);
        CryostatContainer.allPermissionsAndDeleteOnExit(root);
        if (subFolders != null) {
            subFolders.forEach(folder -> {
                try {
                    CryostatContainer.allPermissionsAndDeleteOnExit(Files.createDirectories(Path.of(root.toAbsolutePath().toString(), folder), new FileAttribute[0]));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return root;
    }

    private static void allPermissionsAndDeleteOnExit(Path directory) {
        File file = directory.toFile();
        file.setReadable(true, false);
        file.setWritable(true, false);
        file.setExecutable(true, false);
        file.deleteOnExit();
    }

    static {
        try {
            CONF_PATH = CryostatContainer.createFolder("cryostat-conf", Stream.of("rules", "metadata"));
            PROBES_PATH = CryostatContainer.createFolder("cryostat-probes", null);
            RECORDINGS_PATH = CryostatContainer.createFolder("cryostat-recordings", Stream.of("file-uploads"));
            TEMPLATES_PATH = CryostatContainer.createFolder("cryostat-templates", null);
            CLIENTLIB_PATH = CryostatContainer.createFolder("cryostat-clientlib", null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

