/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.service;

import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.Deployable;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.service.ConfigurableService;
import software.tnb.common.service.Service;
import software.tnb.common.service.configuration.ServiceConfiguration;

public final class ServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceFactory.class);

    private ServiceFactory() {
    }

    public static <S extends Service> S create(Class<S> clazz) {
        if (ReflectionUtils.isAbstract(clazz) || clazz.isInterface()) {
            ServiceLoader<S> loader = ServiceLoader.load(clazz);
            if (loader.stream().findAny().isEmpty()) {
                LOG.error("No Service class implementation for class {} found!", (Object)clazz.getSimpleName());
                throw new IllegalArgumentException();
            }
            if (loader.stream().count() == 1L) {
                return (S)((Service)loader.findFirst().get());
            }
            Optional<Service> service = StreamSupport.stream(loader.spliterator(), false).filter(s -> {
                if (OpenshiftConfiguration.isOpenshift()) {
                    return s instanceof OpenshiftDeployable || s.getClass().getSimpleName().toLowerCase().contains("openshift");
                }
                return s instanceof Deployable || s.getClass().getSimpleName().toLowerCase().contains("local");
            }).findFirst();
            if (service.isEmpty()) {
                LOG.error("No Service class implementation for class {} / environment {} found!", (Object)clazz.getSimpleName(), (Object)(OpenshiftConfiguration.isOpenshift() ? "openshift" : "local"));
                throw new IllegalArgumentException();
            }
            return (S)service.get();
        }
        return (S)((Service)Try.call(() -> (Service)ReflectionUtils.newInstance((Class)clazz, (Object[])new Object[0])).getOrThrow(e -> new IllegalArgumentException("Failed to instantiate class " + clazz.getSimpleName(), (Throwable)e)));
    }

    public static <C extends ServiceConfiguration, S extends ConfigurableService<C>> S create(Class<S> clazz, Consumer<C> config) {
        ConfigurableService service = (ConfigurableService)ServiceFactory.create(clazz);
        config.accept(service.getConfiguration());
        return (S)service;
    }

    public static <S extends Service> void withService(Class<S> clazz, Consumer<S> code) {
        ServiceFactory.withService(ServiceFactory.create(clazz), code);
    }

    public static <C extends ServiceConfiguration, S extends ConfigurableService<C>> void withService(Class<S> clazz, Consumer<C> config, Consumer<S> code) {
        ServiceFactory.withService(ServiceFactory.create(clazz, config), code);
    }

    private static <S extends Service> void withService(S service, Consumer<S> code) {
        try {
            service.beforeAll(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            code.accept(service);
        }
        finally {
            try {
                service.afterAll(null);
            }
            catch (Exception e) {
                LOG.warn("Exception thrown while undeploying service", (Throwable)e);
            }
        }
    }
}

