/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.deployment;

import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionConfig;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.WaitUtils;

public interface WithOperatorHub {
    public String operatorName();

    default public String operatorCatalog() {
        return "redhat-operators";
    }

    default public String operatorCatalogNamespace() {
        return "openshift-marketplace";
    }

    default public String operatorChannel() {
        return "stable";
    }

    default public String subscriptionName() {
        return "tnb-" + this.getSuperClassName();
    }

    default public String targetNamespace() {
        return OpenshiftClient.get().getNamespace();
    }

    default public String getOperatorCatalog() {
        return this.getValue("operator.catalog", this.operatorCatalog());
    }

    default public String getOperatorChannel() {
        return this.getValue("operator.channel", this.operatorChannel());
    }

    default public String getOperatorName() {
        return this.getValue("operator.name", this.operatorName());
    }

    default public String getOperatorCatalogNamespace() {
        return this.getValue("catalog.namespace", this.operatorCatalogNamespace());
    }

    default public boolean clusterWide() {
        return false;
    }

    default public void createSubscription() {
        OpenshiftClient.get().createSubscription(this.getOperatorChannel(), this.getOperatorName(), this.getOperatorCatalog(), this.subscriptionName(), this.getOperatorCatalogNamespace(), this.targetNamespace(), this.clusterWide(), null, (SubscriptionConfig)Optional.ofNullable(this.getOperatorEnvVariables()).map(envVars -> {
            SubscriptionConfig config = new SubscriptionConfig();
            config.setEnv(envVars);
            return config;
        }).orElse(null));
        OpenshiftClient.get().waitForInstallPlanToComplete(this.subscriptionName(), this.targetNamespace());
    }

    default public List<EnvVar> getOperatorEnvVariables() {
        return null;
    }

    default public void deleteSubscription(BooleanSupplier waitCondition) {
        OpenshiftClient.get().deleteSubscription(this.subscriptionName(), this.targetNamespace());
        WaitUtils.waitFor((BooleanSupplier)waitCondition, (String)"Waiting until the operator is undeployed");
    }

    private String getValue(String property, String defaultValue) {
        return Optional.ofNullable(System.getProperty(this.getSuperClassName() + "." + property)).orElse(defaultValue);
    }

    private String getSuperClassName() {
        Class<?> superclass = this.getClass().getSuperclass();
        if (Object.class.equals(superclass)) {
            throw new IllegalStateException("Current class " + this.getClass().getSimpleName() + " does not extend any other class and default method from WithOperatorHub was called, either override this method or check what's wrong as this shouldn't happen");
        }
        return superclass.getSimpleName().toLowerCase();
    }
}

