/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.deployment;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Readiable;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.tnb.common.config.TestConfiguration;
import software.tnb.common.deployment.Deployable;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.WaitUtils;

public interface OpenshiftDeployable
extends Deployable {
    public void create();

    default public boolean isReady() {
        List<PodResource<Pod>> servicePods = this.servicePods();
        return servicePods != null && servicePods.size() > 0 && servicePods.stream().allMatch(Readiable::isReady);
    }

    public boolean isDeployed();

    default public long waitTime() {
        return 300000L;
    }

    default public PodResource<Pod> servicePod() {
        return this.servicePods().size() > 0 ? this.servicePods().get(0) : null;
    }

    default public List<PodResource<Pod>> servicePods() {
        try {
            return ((PodList)OpenshiftClient.get().pods().list()).getItems().stream().filter(this.podSelector()).map(p -> (PodResource)OpenshiftClient.get().pods().withName(p.getMetadata().getName())).collect(Collectors.toList());
        }
        catch (KubernetesClientException kce) {
            return null;
        }
    }

    public Predicate<Pod> podSelector();

    @Override
    default public void deploy() {
        int retries = 60;
        if (!this.isDeployed()) {
            this.create();
        }
        WaitUtils.waitFor(this::isReady, (int)60, (long)(this.waitTime() / 60L), (String)("Waiting until the " + this.getClass().getSimpleName() + " resource is ready"));
    }

    @Override
    default public void afterAll(ExtensionContext extensionContext) throws Exception {
        Deployable.super.afterAll(extensionContext);
        if (TestConfiguration.parallel()) {
            OpenshiftClient.deleteNamespace();
        }
    }

    @Override
    default public void restart() {
        this.closeResources();
        this.servicePod().delete();
        WaitUtils.waitFor(() -> this.servicePods().stream().allMatch(p -> p.isReady() && !((Pod)p.get()).isMarkedForDeletion()), (String)"Restart: Waiting until the service is restarted");
        this.openResources();
    }
}

