/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.deployment;

import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public interface Deployable
extends BeforeAllCallback,
AfterAllCallback {
    public void deploy();

    public void undeploy();

    public void openResources();

    public void closeResources();

    default public void beforeAll(ExtensionContext extensionContext) throws Exception {
        try {
            this.deploy();
            this.openResources();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    default public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.closeResources();
        this.undeploy();
    }

    default public void restart() {
        this.closeResources();
        this.undeploy();
        this.deploy();
        this.openResources();
    }
}

