/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.account.loader;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.Account;

public abstract class CredentialsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialsLoader.class);
    protected final ObjectMapper mapper = new ObjectMapper();

    public abstract Object loadCredentials(String var1);

    public abstract String toJson(Object var1);

    public CredentialsLoader() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public <T extends Account> T get(List<String> credentialsIds, Class<T> accountClass) {
        Account account = null;
        try {
            for (String id : credentialsIds) {
                Object credentials = this.loadCredentials(id);
                if (credentials != null) {
                    if (account == null) {
                        LOG.trace("Creating {} instance from credentials {}", (Object)accountClass.getSimpleName(), (Object)id);
                        account = (Account)this.mapper.readValue(this.toJson(credentials), accountClass);
                        continue;
                    }
                    LOG.trace("Updating {} instance with credentials {}", (Object)accountClass.getSimpleName(), (Object)id);
                    this.mapper.readerForUpdating(account).readValue(this.toJson(credentials));
                    continue;
                }
                LOG.trace("Account with id {} not found in credentials", (Object)id);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldnt get credentials from ids: " + String.join((CharSequence)",", credentialsIds), e);
        }
        if (account == null) {
            throw new IllegalArgumentException(String.format("Unable to create %s instance from credentials [%s] - no credentials with given ids found", accountClass.getSimpleName(), String.join((CharSequence)",", credentialsIds)));
        }
        return (T)account;
    }
}

