/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.deployment;

import org.junit.jupiter.api.extension.ExtensionContext;
import software.tnb.common.config.TestConfiguration;
import software.tnb.common.deployment.Deployable;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.WaitUtils;

public interface OpenshiftDeployable
extends Deployable {
    public void create();

    public boolean isReady();

    public boolean isDeployed();

    default public long waitTime() {
        return 300000L;
    }

    @Override
    default public void deploy() {
        int retries = 60;
        if (!this.isDeployed()) {
            this.create();
        }
        WaitUtils.waitFor(this::isReady, (int)60, (long)(this.waitTime() / 60L), (String)("Waiting until the " + this.getClass().getSimpleName() + " resource is ready"));
    }

    @Override
    default public void afterAll(ExtensionContext extensionContext) throws Exception {
        Deployable.super.afterAll(extensionContext);
        if (TestConfiguration.parallel()) {
            OpenshiftClient.deleteNamespace();
        }
    }
}

