/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.account.loader;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.response.AuthResponse;
import com.bettercloud.vault.response.LogicalResponse;
import org.junit.jupiter.api.function.ThrowingSupplier;
import software.tnb.common.account.loader.CredentialsLoader;

public class VaultCredentialsLoader
extends CredentialsLoader {
    private final Vault vault;
    private final String pathPattern;
    private final VaultConfig config;
    private ThrowingSupplier<AuthResponse> authSupplier;

    private VaultCredentialsLoader(String address, String pathPattern) throws VaultException {
        this.config = new VaultConfig().address(address).engineVersion(Integer.valueOf(2)).build();
        this.vault = new Vault(this.config);
        this.pathPattern = pathPattern;
    }

    public VaultCredentialsLoader(String address, String pathPattern, String ghToken) throws VaultException {
        this(address, pathPattern);
        this.authSupplier = () -> this.vault.auth().loginByGithub(ghToken);
    }

    public VaultCredentialsLoader(String address, String pathPattern, String roleId, String secretId) throws VaultException {
        this(address, pathPattern);
        this.authSupplier = () -> this.vault.auth().loginByAppRole(roleId, secretId);
    }

    private void refreshAuthToken() {
        try {
            this.config.token(((AuthResponse)this.authSupplier.get()).getAuthClientToken()).build();
        }
        catch (Throwable e) {
            throw new RuntimeException("Vault reauth failed", e);
        }
    }

    @Override
    public Object loadCredentials(String credentialsId) {
        this.refreshAuthToken();
        return this.get(String.format(this.pathPattern, credentialsId));
    }

    @Override
    public String toJson(Object credentials) {
        return credentials.toString();
    }

    private JsonObject get(String path) {
        LogicalResponse response;
        try {
            response = this.vault.logical().read(path);
        }
        catch (VaultException e) {
            throw new RuntimeException("Unable to read credentials from vault", e);
        }
        if (response.getRestResponse().getStatus() == 200) {
            return response.getDataObject();
        }
        if (response.getRestResponse().getStatus() == 404) {
            return null;
        }
        throw new RuntimeException("Unable to get credentials from vault, response code: " + response.getRestResponse().getStatus());
    }
}

